/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import javax.security.auth.callback.CallbackHandler;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.exceptions.TransportException;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.core.security.ServerAuthenticationProvider;
import org.infinispan.server.core.security.simple.SimpleServerAuthenticationProvider;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.server.hotrod.test.TestCallbackHandler;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.AuthenticationTest", groups={"functional"})
@CleanupAfterMethod
public class AuthenticationTest
extends SingleCacheManagerTest {
    private static final Log log = LogFactory.getLog(AuthenticationTest.class);
    private RemoteCacheManager remoteCacheManager;
    protected HotRodServer hotrodServer;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        this.cacheManager = TestCacheManagerFactory.createCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration());
        this.cacheManager.getCache();
        return this.cacheManager;
    }

    private ConfigurationBuilder initServerAndClient() {
        this.hotrodServer = new HotRodServer();
        HotRodServerConfigurationBuilder serverBuilder = HotRodTestingUtil.getDefaultHotRodConfiguration();
        SimpleServerAuthenticationProvider sap = new SimpleServerAuthenticationProvider();
        sap.addUser("user", "realm", "password".toCharArray(), null);
        serverBuilder.authentication().enable().serverName("localhost").addAllowedMech("CRAM-MD5").serverAuthenticationProvider((ServerAuthenticationProvider)sap);
        this.hotrodServer.start((ProtocolServerConfiguration)serverBuilder.build(), this.cacheManager);
        log.info((Object)("Started server on port: " + this.hotrodServer.getPort()));
        ConfigurationBuilder clientBuilder = new ConfigurationBuilder();
        clientBuilder.addServer().host("127.0.0.1").port(this.hotrodServer.getPort()).socketTimeout(3000).connectionPool().maxActive(1).security().authentication().enable().saslMechanism("CRAM-MD5").connectionPool().timeBetweenEvictionRuns(2000L);
        return clientBuilder;
    }

    @Test
    public void testAuthentication() {
        ConfigurationBuilder clientBuilder = this.initServerAndClient();
        clientBuilder.security().authentication().callbackHandler((CallbackHandler)new TestCallbackHandler("user", "realm", "password".toCharArray()));
        this.remoteCacheManager = new RemoteCacheManager(clientBuilder.build());
        RemoteCache defaultRemote = this.remoteCacheManager.getCache();
        defaultRemote.put((Object)"a", (Object)"a");
        AssertJUnit.assertEquals((String)"a", (String)((String)defaultRemote.get((Object)"a")));
    }

    @Test(expectedExceptions={TransportException.class})
    public void testAuthenticationFail() {
        ConfigurationBuilder clientBuilder = this.initServerAndClient();
        clientBuilder.security().authentication().callbackHandler((CallbackHandler)new TestCallbackHandler("user", "realm", "foobar".toCharArray()));
        this.remoteCacheManager = new RemoteCacheManager(clientBuilder.build());
        this.remoteCacheManager.getCache();
    }

    protected void teardown() {
        HotRodClientTestingUtil.killRemoteCacheManager(this.remoteCacheManager);
        HotRodClientTestingUtil.killServers(this.hotrodServer);
        super.teardown();
    }
}

