/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.lang.reflect.Method;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.ExpiryTest")
public class ExpiryTest
extends MultiHotRodServersTest {
    public static final int EXPIRATION_TIMEOUT = 3000;
    public static final int EVICTION_CHECK_TIMEOUT = 2000;

    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder builder = ExpiryTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC, (boolean)false);
        builder.expiration().lifespan(3000L);
        this.createHotRodServers(1, builder);
    }

    public void testGlobalExpiry(Method m) throws Exception {
        RemoteCacheManager client0 = this.client(0);
        RemoteCache cache0 = client0.getCache();
        String v1 = TestingUtil.v((Method)m);
        cache0.put((Object)1, (Object)v1);
        this.expectCachedThenExpired(1, (RemoteCache<Integer, String>)cache0);
    }

    private void expectCachedThenExpired(Integer key, RemoteCache<Integer, String> cache) {
        long startTime = TestingUtil.now();
        long expiration = 3000L;
        TestingUtil.sleepThread((long)5000L);
        while (!TestingUtil.moreThanDurationElapsed((long)startTime, (long)5000L)) {
            if (cache.get((Object)key) != null) continue;
            return;
        }
        AssertJUnit.assertNull((Object)cache.get((Object)key));
    }
}

