/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.event;

import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.event.CustomEventLogListener;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.RemoteCacheManagerCallable;
import org.infinispan.client.hotrod.test.SingleHotRodServerTest;
import org.infinispan.notifications.cachelistener.filter.CacheEventConverterFactory;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.event.ClientCustomEventsTest")
public class ClientCustomEventsTest
extends SingleHotRodServerTest {
    @Override
    protected HotRodServer createHotRodServer() {
        HotRodServerConfigurationBuilder builder = new HotRodServerConfigurationBuilder();
        HotRodServer server = HotRodClientTestingUtil.startHotRodServer(this.cacheManager, builder);
        server.addCacheEventConverterFactory("static-converter-factory", (CacheEventConverterFactory)new CustomEventLogListener.StaticConverterFactory());
        server.addCacheEventConverterFactory("dynamic-converter-factory", (CacheEventConverterFactory)new CustomEventLogListener.DynamicConverterFactory());
        server.addCacheEventConverterFactory("raw-static-converter-factory", (CacheEventConverterFactory)new CustomEventLogListener.RawStaticConverterFactory());
        return server;
    }

    public void testCustomEvents() {
        final CustomEventLogListener.StaticCustomEventLogListener eventListener = new CustomEventLogListener.StaticCustomEventLogListener();
        HotRodClientTestingUtil.withClientListener(eventListener, new RemoteCacheManagerCallable(this.remoteCacheManager){

            @Override
            public void call() {
                RemoteCache cache = this.rcm.getCache();
                eventListener.expectNoEvents();
                cache.put((Object)1, (Object)"one");
                eventListener.expectOnlyCreatedCustomEvent(new CustomEventLogListener.CustomEvent(1, "one"));
                cache.put((Object)1, (Object)"newone");
                eventListener.expectOnlyModifiedCustomEvent(new CustomEventLogListener.CustomEvent(1, "newone"));
                cache.remove((Object)1);
                eventListener.expectOnlyRemovedCustomEvent(new CustomEventLogListener.CustomEvent(1, null));
            }
        });
    }

    @Test(expectedExceptions={HotRodClientException.class})
    public void testNonExistingConverterFactoryCustomEvents() {
        NonExistingConverterFactoryListener eventListener = new NonExistingConverterFactoryListener();
        HotRodClientTestingUtil.withClientListener(eventListener, new RemoteCacheManagerCallable(this.remoteCacheManager));
    }

    public void testParameterBasedConversion() {
        final CustomEventLogListener.DynamicCustomEventLogListener eventListener = new CustomEventLogListener.DynamicCustomEventLogListener();
        HotRodClientTestingUtil.withClientListener(eventListener, null, new Object[]{2}, new RemoteCacheManagerCallable(this.remoteCacheManager){

            @Override
            public void call() {
                RemoteCache cache = this.rcm.getCache();
                eventListener.expectNoEvents();
                cache.put((Object)1, (Object)"one");
                eventListener.expectOnlyCreatedCustomEvent(new CustomEventLogListener.CustomEvent(1, "one"));
                cache.put((Object)2, (Object)"two");
                eventListener.expectOnlyCreatedCustomEvent(new CustomEventLogListener.CustomEvent(2, null));
            }
        });
    }

    public void testConvertedEventsReplay() {
        final CustomEventLogListener.StaticCustomEventLogWithStateListener staticEventListener = new CustomEventLogListener.StaticCustomEventLogWithStateListener();
        RemoteCache cache = this.remoteCacheManager.getCache();
        cache.put((Object)1, (Object)"one");
        HotRodClientTestingUtil.withClientListener(staticEventListener, new RemoteCacheManagerCallable(this.remoteCacheManager){

            @Override
            public void call() {
                staticEventListener.expectOnlyCreatedCustomEvent(new CustomEventLogListener.CustomEvent(1, "one"));
            }
        });
        final CustomEventLogListener.DynamicCustomEventWithStateLogListener dynamicEventListener = new CustomEventLogListener.DynamicCustomEventWithStateLogListener();
        cache.put((Object)2, (Object)"two");
        HotRodClientTestingUtil.withClientListener(dynamicEventListener, null, new Object[]{2}, new RemoteCacheManagerCallable(this.remoteCacheManager){

            @Override
            public void call() {
                dynamicEventListener.expectOnlyCreatedCustomEvent(new CustomEventLogListener.CustomEvent(2, null));
            }
        });
    }

    public void testConvertedNoEventsReplay() {
        final CustomEventLogListener.StaticCustomEventLogListener staticEventListener = new CustomEventLogListener.StaticCustomEventLogListener();
        RemoteCache cache = this.remoteCacheManager.getCache();
        cache.put((Object)1, (Object)"one");
        HotRodClientTestingUtil.withClientListener(staticEventListener, new RemoteCacheManagerCallable(this.remoteCacheManager){

            @Override
            public void call() {
                staticEventListener.expectNoEvents();
            }
        });
        CustomEventLogListener.DynamicCustomEventLogListener dynamicEventListener = new CustomEventLogListener.DynamicCustomEventLogListener();
        cache.put((Object)2, (Object)"two");
        HotRodClientTestingUtil.withClientListener(dynamicEventListener, null, new Object[]{2}, new RemoteCacheManagerCallable(this.remoteCacheManager){

            @Override
            public void call() {
                staticEventListener.expectNoEvents();
            }
        });
    }

    public void testRawCustomEvents() {
        final CustomEventLogListener.RawStaticCustomEventLogListener eventListener = new CustomEventLogListener.RawStaticCustomEventLogListener();
        HotRodClientTestingUtil.withClientListener(eventListener, new RemoteCacheManagerCallable(this.remoteCacheManager){

            @Override
            public void call() {
                RemoteCache cache = this.rcm.getCache();
                eventListener.expectNoEvents();
                cache.put((Object)1, (Object)"one");
                eventListener.expectOnlyCreatedCustomEvent(new byte[]{3, 75, 0, 0, 0, 1, 3, 62, 3, 111, 110, 101});
                cache.put((Object)1, (Object)"newone");
                eventListener.expectOnlyModifiedCustomEvent(new byte[]{3, 75, 0, 0, 0, 1, 3, 62, 6, 110, 101, 119, 111, 110, 101});
                cache.remove((Object)1);
                eventListener.expectOnlyRemovedCustomEvent(new byte[]{3, 75, 0, 0, 0, 1});
            }
        });
    }

    @ClientListener(converterFactoryName="non-existing-test-converter-factory")
    public static class NonExistingConverterFactoryListener
    extends CustomEventLogListener {
    }
}

