/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.event;

import java.io.Serializable;
import java.util.Set;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.VersionedValue;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.event.ClientEvent;
import org.infinispan.client.hotrod.event.EventLogListener;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.RemoteCacheManagerCallable;
import org.infinispan.client.hotrod.test.SingleHotRodServerTest;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.event.ClientEventsTest")
public class ClientEventsTest
extends SingleHotRodServerTest {
    public void testCreatedEvent() {
        final EventLogListener eventListener = new EventLogListener();
        HotRodClientTestingUtil.withClientListener(eventListener, new RemoteCacheManagerCallable(this.remoteCacheManager){

            @Override
            public void call() {
                RemoteCache cache = this.rcm.getCache();
                eventListener.expectNoEvents();
                cache.put((Object)1, (Object)"one");
                eventListener.expectOnlyCreatedEvent(1, ClientEventsTest.this.cache());
                cache.put((Object)2, (Object)"two");
                eventListener.expectOnlyCreatedEvent(2, ClientEventsTest.this.cache());
            }
        });
    }

    public void testModifiedEvent() {
        final EventLogListener eventListener = new EventLogListener();
        HotRodClientTestingUtil.withClientListener(eventListener, new RemoteCacheManagerCallable(this.remoteCacheManager){

            @Override
            public void call() {
                RemoteCache cache = this.rcm.getCache();
                eventListener.expectNoEvents();
                cache.put((Object)1, (Object)"one");
                eventListener.expectOnlyCreatedEvent(1, ClientEventsTest.this.cache());
                cache.put((Object)1, (Object)"newone");
                eventListener.expectOnlyModifiedEvent(1, ClientEventsTest.this.cache());
            }
        });
    }

    public void testRemovedEvent() {
        final EventLogListener eventListener = new EventLogListener();
        HotRodClientTestingUtil.withClientListener(eventListener, new RemoteCacheManagerCallable(this.remoteCacheManager){

            @Override
            public void call() {
                RemoteCache cache = this.rcm.getCache();
                eventListener.expectNoEvents();
                cache.remove((Object)1);
                eventListener.expectNoEvents();
                cache.put((Object)1, (Object)"one");
                eventListener.expectOnlyCreatedEvent(1, ClientEventsTest.this.cache());
                cache.remove((Object)1);
                eventListener.expectOnlyRemovedEvent(1, ClientEventsTest.this.cache());
            }
        });
    }

    public void testReplaceEvents() {
        final EventLogListener eventListener = new EventLogListener();
        HotRodClientTestingUtil.withClientListener(eventListener, new RemoteCacheManagerCallable(this.remoteCacheManager){

            @Override
            public void call() {
                RemoteCache cache = this.rcm.getCache();
                eventListener.expectNoEvents();
                cache.replace((Object)1, (Object)"one");
                eventListener.expectNoEvents();
                cache.put((Object)1, (Object)"one");
                eventListener.expectOnlyCreatedEvent(1, ClientEventsTest.this.cache());
                cache.replace((Object)1, (Object)"newone");
                eventListener.expectOnlyModifiedEvent(1, ClientEventsTest.this.cache());
            }
        });
    }

    public void testPutIfAbsentEvents() {
        final EventLogListener eventListener = new EventLogListener();
        HotRodClientTestingUtil.withClientListener(eventListener, new RemoteCacheManagerCallable(this.remoteCacheManager){

            @Override
            public void call() {
                RemoteCache cache = this.rcm.getCache();
                eventListener.expectNoEvents();
                cache.putIfAbsent((Object)1, (Object)"one");
                eventListener.expectOnlyCreatedEvent(1, ClientEventsTest.this.cache());
                cache.putIfAbsent((Object)1, (Object)"newone");
                eventListener.expectNoEvents();
            }
        });
    }

    public void testReplaceIfUnmodifiedEvents() {
        final EventLogListener eventListener = new EventLogListener();
        HotRodClientTestingUtil.withClientListener(eventListener, new RemoteCacheManagerCallable(this.remoteCacheManager){

            @Override
            public void call() {
                RemoteCache cache = this.rcm.getCache();
                eventListener.expectNoEvents();
                cache.replaceWithVersion((Object)1, (Object)"one", 0L);
                eventListener.expectNoEvents();
                cache.putIfAbsent((Object)1, (Object)"one");
                eventListener.expectOnlyCreatedEvent(1, ClientEventsTest.this.cache());
                cache.replaceWithVersion((Object)1, (Object)"one", 0L);
                eventListener.expectNoEvents();
                VersionedValue versioned = cache.getVersioned((Object)1);
                cache.replaceWithVersion((Object)1, (Object)"one", versioned.getVersion());
                eventListener.expectOnlyModifiedEvent(1, ClientEventsTest.this.cache());
            }
        });
    }

    public void testRemoveIfUnmodifiedEvents() {
        final EventLogListener eventListener = new EventLogListener();
        HotRodClientTestingUtil.withClientListener(eventListener, new RemoteCacheManagerCallable(this.remoteCacheManager){

            @Override
            public void call() {
                RemoteCache cache = this.rcm.getCache();
                eventListener.expectNoEvents();
                cache.removeWithVersion((Object)1, 0L);
                eventListener.expectNoEvents();
                cache.putIfAbsent((Object)1, (Object)"one");
                eventListener.expectOnlyCreatedEvent(1, ClientEventsTest.this.cache());
                cache.removeWithVersion((Object)1, 0L);
                eventListener.expectNoEvents();
                VersionedValue versioned = cache.getVersioned((Object)1);
                cache.removeWithVersion((Object)1, versioned.getVersion());
                eventListener.expectOnlyRemovedEvent(1, ClientEventsTest.this.cache());
            }
        });
    }

    public void testClearEvents() {
        final EventLogListener eventListener = new EventLogListener();
        HotRodClientTestingUtil.withClientListener(eventListener, new RemoteCacheManagerCallable(this.remoteCacheManager){

            @Override
            public void call() {
                RemoteCache cache = this.rcm.getCache();
                eventListener.expectNoEvents();
                cache.put((Object)1, (Object)"one");
                eventListener.expectOnlyCreatedEvent(1, ClientEventsTest.this.cache());
                cache.put((Object)2, (Object)"two");
                eventListener.expectOnlyCreatedEvent(2, ClientEventsTest.this.cache());
                cache.put((Object)3, (Object)"three");
                eventListener.expectOnlyCreatedEvent(3, ClientEventsTest.this.cache());
                cache.clear();
                eventListener.expectUnorderedEvents(ClientEvent.Type.CLIENT_CACHE_ENTRY_REMOVED, 1, 2, 3);
            }
        });
    }

    public void testNoEventsBeforeAddingListener() {
        final EventLogListener eventListener = new EventLogListener();
        RemoteCache rcache = this.remoteCacheManager.getCache();
        rcache.put((Object)1, (Object)"one");
        eventListener.expectNoEvents();
        rcache.put((Object)1, (Object)"newone");
        eventListener.expectNoEvents();
        rcache.remove((Object)1);
        eventListener.expectNoEvents();
        HotRodClientTestingUtil.withClientListener(eventListener, new RemoteCacheManagerCallable(this.remoteCacheManager){

            @Override
            public void call() {
                RemoteCache cache = this.rcm.getCache();
                cache.put((Object)1, (Object)"one");
                eventListener.expectOnlyCreatedEvent(1, ClientEventsTest.this.cache());
                cache.put((Object)1, (Object)"newone");
                eventListener.expectOnlyModifiedEvent(1, ClientEventsTest.this.cache());
                cache.remove((Object)1);
                eventListener.expectOnlyRemovedEvent(1, ClientEventsTest.this.cache());
            }
        });
    }

    public void testNoEventsAfterRemovingListener() {
        final EventLogListener eventListener = new EventLogListener();
        final RemoteCache rcache = this.remoteCacheManager.getCache();
        HotRodClientTestingUtil.withClientListener(eventListener, new RemoteCacheManagerCallable(this.remoteCacheManager){

            @Override
            public void call() {
                rcache.put((Object)1, (Object)"one");
                eventListener.expectOnlyCreatedEvent(1, ClientEventsTest.this.cache());
                rcache.put((Object)1, (Object)"newone");
                eventListener.expectOnlyModifiedEvent(1, ClientEventsTest.this.cache());
                rcache.remove((Object)1);
                eventListener.expectOnlyRemovedEvent(1, ClientEventsTest.this.cache());
            }
        });
        rcache.put((Object)1, (Object)"one");
        eventListener.expectNoEvents();
        rcache.put((Object)1, (Object)"newone");
        eventListener.expectNoEvents();
        rcache.remove((Object)1);
        eventListener.expectNoEvents();
    }

    public void testSetListeners() {
        final EventLogListener eventListener1 = new EventLogListener();
        final RemoteCache rcache = this.remoteCacheManager.getCache();
        HotRodClientTestingUtil.withClientListener(eventListener1, new RemoteCacheManagerCallable(this.remoteCacheManager){

            @Override
            public void call() {
                Set listeners = rcache.getListeners();
                AssertJUnit.assertEquals((int)1, (int)listeners.size());
                AssertJUnit.assertEquals((Object)eventListener1, listeners.iterator().next());
                final EventLogListener eventListener2 = new EventLogListener();
                HotRodClientTestingUtil.withClientListener(eventListener2, new RemoteCacheManagerCallable(ClientEventsTest.this.remoteCacheManager){

                    @Override
                    public void call() {
                        Set listeners = rcache.getListeners();
                        AssertJUnit.assertEquals((int)2, (int)listeners.size());
                        AssertJUnit.assertTrue((boolean)listeners.contains(eventListener1));
                        AssertJUnit.assertTrue((boolean)listeners.contains(eventListener2));
                    }
                });
            }
        });
        Set listeners = rcache.getListeners();
        AssertJUnit.assertEquals((int)0, (int)listeners.size());
    }

    public void testCustomTypeEvents() {
        final EventLogListener eventListener = new EventLogListener();
        HotRodClientTestingUtil.withClientListener(eventListener, new RemoteCacheManagerCallable(this.remoteCacheManager){

            @Override
            public void call() {
                RemoteCache cache = this.rcm.getCache();
                eventListener.expectNoEvents();
                CustomKey key = new CustomKey(1);
                cache.put((Object)key, (Object)"one");
                eventListener.expectOnlyCreatedEvent(key, ClientEventsTest.this.cache());
                cache.replace((Object)key, (Object)"newone");
                eventListener.expectOnlyModifiedEvent(key, ClientEventsTest.this.cache());
                cache.remove((Object)key);
                eventListener.expectOnlyRemovedEvent(key, ClientEventsTest.this.cache());
            }
        });
    }

    public void testEventReplayAfterAddingListener() {
        final WithStateEventLogListener eventListener = new WithStateEventLogListener();
        RemoteCache cache = this.remoteCacheManager.getCache();
        cache.put((Object)1, (Object)"one");
        cache.put((Object)2, (Object)"two");
        eventListener.expectNoEvents();
        HotRodClientTestingUtil.withClientListener(eventListener, new RemoteCacheManagerCallable(this.remoteCacheManager){

            @Override
            public void call() {
                eventListener.expectUnorderedEvents(ClientEvent.Type.CLIENT_CACHE_ENTRY_CREATED, 1, 2);
            }
        });
    }

    public void testNoEventReplayAfterAddingListener() {
        final EventLogListener eventListener = new EventLogListener();
        RemoteCache cache = this.remoteCacheManager.getCache();
        cache.put((Object)1, (Object)"one");
        cache.put((Object)2, (Object)"two");
        eventListener.expectNoEvents();
        HotRodClientTestingUtil.withClientListener(eventListener, new RemoteCacheManagerCallable(this.remoteCacheManager){

            @Override
            public void call() {
                eventListener.expectNoEvents();
            }
        });
    }

    static final class CustomKey
    implements Serializable {
        final int id;

        CustomKey(int id) {
            this.id = id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CustomKey customKey = (CustomKey)o;
            return this.id == customKey.id;
        }

        public int hashCode() {
            return this.id;
        }
    }

    @ClientListener(includeCurrentState=true)
    public static class WithStateEventLogListener<K>
    extends EventLogListener<K> {
    }
}

