/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.near;

import java.util.ArrayList;
import java.util.List;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.NearCacheMode;
import org.infinispan.client.hotrod.near.AssertsNearCache;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.near.ClusterEagerNearCacheTest")
public class ClusterEagerNearCacheTest
extends MultiHotRodServersTest {
    List<AssertsNearCache<Integer, String>> assertClients = new ArrayList<AssertsNearCache<Integer, String>>(2);

    protected void createCacheManagers() throws Throwable {
        this.createHotRodServers(2, this.getCacheConfiguration());
    }

    private org.infinispan.configuration.cache.ConfigurationBuilder getCacheConfiguration() {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = ClusterEagerNearCacheTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false);
        builder.clustering().hash().numOwners(1);
        return HotRodTestingUtil.hotRodCacheConfiguration((org.infinispan.configuration.cache.ConfigurationBuilder)builder);
    }

    @Override
    protected RemoteCacheManager createClient(int i) {
        AssertsNearCache asserts = this.createAssertClient();
        this.assertClients.add(asserts);
        return asserts.manager;
    }

    private <K, V> AssertsNearCache<K, V> createAssertClient() {
        ConfigurationBuilder clientBuilder = new ConfigurationBuilder();
        for (HotRodServer server : this.servers) {
            clientBuilder.addServer().host("127.0.0.1").port(server.getPort());
        }
        clientBuilder.nearCache().mode(this.getNearCacheMode());
        return AssertsNearCache.create(this.cache(0), clientBuilder);
    }

    protected NearCacheMode getNearCacheMode() {
        return NearCacheMode.EAGER;
    }

    public void testNearCacheUpdatesSeenByAllClients() {
        Integer key0 = HotRodClientTestingUtil.getIntKeyForServer(this.server(0));
        Integer key1 = HotRodClientTestingUtil.getIntKeyForServer(this.server(1));
        this.expectNearCacheUpdates(this.headClient(), key0, this.tailClient());
        this.expectNearCacheUpdates(this.tailClient(), key1, this.headClient());
    }

    protected void expectNearCacheUpdates(AssertsNearCache<Integer, String> producer, Integer key, AssertsNearCache<Integer, String> consumer) {
        producer.get(key, null).expectNearGetNull(key);
        producer.put(key, "v1").expectNearPut(key, "v1", consumer);
        producer.get(key, "v1").expectNearGetValue(key, "v1");
        producer.put(key, "v2").expectNearPut(key, "v2", consumer);
        producer.get(key, "v2").expectNearGetValue(key, "v2");
        producer.remove(key).expectNearRemove(key, consumer);
        producer.get(key, null).expectNearGetNull(key);
    }

    private AssertsNearCache<Integer, String> tailClient() {
        return this.assertClients.get(1);
    }

    private AssertsNearCache<Integer, String> headClient() {
        return this.assertClients.get(0);
    }
}

