/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.near;

import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.NearCacheMode;
import org.infinispan.client.hotrod.near.AssertsNearCache;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.RemoteCacheManagerCallable;
import org.infinispan.client.hotrod.test.SingleHotRodServerTest;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.near.EagerNearCacheTest")
public class EagerNearCacheTest
extends SingleHotRodServerTest {
    AssertsNearCache<Integer, String> assertClient;

    @Override
    protected RemoteCacheManager getRemoteCacheManager() {
        this.assertClient = this.createClient();
        return this.assertClient.manager;
    }

    protected <K, V> AssertsNearCache<K, V> createClient() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.addServer().host("127.0.0.1").port(this.hotrodServer.getPort());
        builder.nearCache().mode(this.getNearCacheMode());
        return AssertsNearCache.create(this.cache(), builder);
    }

    protected NearCacheMode getNearCacheMode() {
        return NearCacheMode.EAGER;
    }

    public void testGetNearCache() {
        this.assertClient.expectNoNearEvents();
        this.assertClient.get(1, null).expectNearGetNull(1);
        this.assertClient.put(1, "v1").expectNearPut(1, "v1", new AssertsNearCache[0]);
        this.assertClient.get(1, "v1").expectNearGetValue(1, "v1");
        this.assertClient.remove(1).expectNearRemove(1, new AssertsNearCache[0]);
        this.assertClient.get(1, null).expectNearGetNull(1);
    }

    public void testGetVersionedNearCache() {
        this.assertClient.expectNoNearEvents();
        this.assertClient.put(1, "v1").expectNearPut(1, "v1", new AssertsNearCache[0]);
        this.assertClient.getVersioned(1, "v1").expectNearGetValueVersion(1, "v1");
        this.assertClient.remove(1).expectNearRemove(1, new AssertsNearCache[0]);
        this.assertClient.getVersioned(1, null).expectNearGetValueVersion(1, null);
    }

    public void testUpdateNearCache() {
        this.assertClient.expectNoNearEvents();
        this.assertClient.put(1, "v1").expectNearPut(1, "v1", new AssertsNearCache[0]);
        this.assertClient.put(1, "v2").expectNearPut(1, "v2", new AssertsNearCache[0]);
        this.assertClient.get(1, "v2").expectNearGetValue(1, "v2");
        this.assertClient.remove(1).expectNearRemove(1, new AssertsNearCache[0]);
    }

    public void testGetUpdatesNearCache() {
        this.assertClient.expectNoNearEvents();
        this.assertClient.put(1, "v1").expectNearPut(1, "v1", new AssertsNearCache[0]);
        final AssertsNearCache newAsserts = this.createClient();
        HotRodClientTestingUtil.withRemoteCacheManager(new RemoteCacheManagerCallable(newAsserts.manager){

            @Override
            public void call() {
                newAsserts.expectNoNearEvents();
                newAsserts.get(1, "v1").expectNearGetNull(1).expectNearPutIfAbsent(1, "v1");
            }
        });
    }
}

