/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.util.HashMap;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.exceptions.RemoteCacheManagerNotStartedException;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.AfterTest;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.CacheManagerStoppedTest", groups={"functional"})
public class CacheManagerStoppedTest
extends SingleCacheManagerTest {
    private static final String CACHE_NAME = "someName";
    EmbeddedCacheManager cacheManager = null;
    HotRodServer hotrodServer = null;
    RemoteCacheManager remoteCacheManager;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        this.cacheManager = TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration());
        this.cacheManager.defineConfiguration(CACHE_NAME, HotRodTestingUtil.hotRodCacheConfiguration().build());
        this.hotrodServer = HotRodClientTestingUtil.startHotRodServer(this.cacheManager);
        this.remoteCacheManager = new RemoteCacheManager("localhost:" + this.hotrodServer.getPort(), true);
        return this.cacheManager;
    }

    @AfterTest
    public void release() {
        HotRodClientTestingUtil.killRemoteCacheManager(this.remoteCacheManager);
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.cacheManager});
        HotRodClientTestingUtil.killServers(this.hotrodServer);
    }

    public void testGetCacheOperations() {
        assert (this.remoteCacheManager.getCache() != null);
        assert (this.remoteCacheManager.getCache(CACHE_NAME) != null);
        this.remoteCache().put((Object)"k", (Object)"v");
        assert (this.remoteCache().get((Object)"k").equals("v"));
    }

    @Test(dependsOnMethods={"testGetCacheOperations"})
    public void testStopCacheManager() {
        assert (this.remoteCacheManager.isStarted());
        this.remoteCacheManager.stop();
        assert (!this.remoteCacheManager.isStarted());
        assert (this.remoteCacheManager.getCache() != null);
        assert (this.remoteCacheManager.getCache(CACHE_NAME) != null);
    }

    @Test(expectedExceptions={RemoteCacheManagerNotStartedException.class}, dependsOnMethods={"testStopCacheManager"})
    public void testGetCacheOperations2() {
        this.remoteCacheManager.getCache().put((Object)"k", (Object)"v");
    }

    @Test(expectedExceptions={RemoteCacheManagerNotStartedException.class}, dependsOnMethods={"testStopCacheManager"})
    public void testGetCacheOperations3() {
        this.remoteCacheManager.getCache(CACHE_NAME).put((Object)"k", (Object)"v");
    }

    @Test(expectedExceptions={RemoteCacheManagerNotStartedException.class}, dependsOnMethods={"testStopCacheManager"})
    public void testPut() {
        this.remoteCache().put((Object)"k", (Object)"v");
    }

    @Test(expectedExceptions={RemoteCacheManagerNotStartedException.class}, dependsOnMethods={"testStopCacheManager"})
    public void testPutAsync() {
        this.remoteCache().putAsync((Object)"k", (Object)"v");
    }

    @Test(expectedExceptions={RemoteCacheManagerNotStartedException.class}, dependsOnMethods={"testStopCacheManager"})
    public void testGet() {
        this.remoteCache().get((Object)"k");
    }

    @Test(expectedExceptions={RemoteCacheManagerNotStartedException.class}, dependsOnMethods={"testStopCacheManager"})
    public void testReplace() {
        this.remoteCache().replace((Object)"k", (Object)"v");
    }

    @Test(expectedExceptions={RemoteCacheManagerNotStartedException.class}, dependsOnMethods={"testStopCacheManager"})
    public void testReplaceAsync() {
        this.remoteCache().replaceAsync((Object)"k", (Object)"v");
    }

    @Test(expectedExceptions={RemoteCacheManagerNotStartedException.class}, dependsOnMethods={"testStopCacheManager"})
    public void testPutAll() {
        this.remoteCache().putAll(new HashMap());
    }

    @Test(expectedExceptions={RemoteCacheManagerNotStartedException.class}, dependsOnMethods={"testStopCacheManager"})
    public void testPutAllAsync() {
        this.remoteCache().putAllAsync(new HashMap());
    }

    @Test(expectedExceptions={RemoteCacheManagerNotStartedException.class}, dependsOnMethods={"testStopCacheManager"})
    public void testVersionedGet() {
        this.remoteCache().getVersioned((Object)"key");
    }

    @Test(expectedExceptions={RemoteCacheManagerNotStartedException.class}, dependsOnMethods={"testStopCacheManager"})
    public void testVersionedRemove() {
        this.remoteCache().removeWithVersion((Object)"key", 12312321L);
    }

    @Test(expectedExceptions={RemoteCacheManagerNotStartedException.class}, dependsOnMethods={"testStopCacheManager"})
    public void testVersionedRemoveAsync() {
        this.remoteCache().removeWithVersionAsync((Object)"key", 12312321L);
    }

    private RemoteCache<Object, Object> remoteCache() {
        return this.remoteCacheManager.getCache();
    }
}

