/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.event;

import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.event.ClientEvent;
import org.infinispan.client.hotrod.event.CustomEventLogListener;
import org.infinispan.client.hotrod.event.EventLogListener;
import org.infinispan.client.hotrod.event.FailoverEventLogListener;
import org.infinispan.client.hotrod.event.StickyServerLoadBalancingStrategy;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.client.hotrod.test.RemoteCacheManagerCallable;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.cachelistener.filter.CacheEventConverterFactory;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilterFactory;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.event.ClientClusterEventsTest")
public class ClientClusterEventsTest
extends MultiHotRodServersTest {
    protected void createCacheManagers() throws Throwable {
        this.createHotRodServers(3, this.getCacheConfiguration());
    }

    private org.infinispan.configuration.cache.ConfigurationBuilder getCacheConfiguration() {
        return HotRodTestingUtil.hotRodCacheConfiguration((org.infinispan.configuration.cache.ConfigurationBuilder)ClientClusterEventsTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC, (boolean)false));
    }

    @Override
    protected HotRodServer addHotRodServer(org.infinispan.configuration.cache.ConfigurationBuilder builder) {
        EmbeddedCacheManager cm = this.addClusterEnabledCacheManager(builder);
        HotRodServerConfigurationBuilder serverBuilder = new HotRodServerConfigurationBuilder();
        HotRodServer server = HotRodClientTestingUtil.startHotRodServer(cm, serverBuilder);
        server.addCacheEventFilterFactory("static-filter-factory", (CacheEventFilterFactory)new EventLogListener.StaticCacheEventFilterFactory());
        server.addCacheEventConverterFactory("static-converter-factory", (CacheEventConverterFactory)new CustomEventLogListener.StaticConverterFactory());
        this.servers.add(server);
        return server;
    }

    public void testEventForwarding() {
        final EventLogListener eventListener = new EventLogListener();
        HotRodClientTestingUtil.withClientListener(eventListener, new RemoteCacheManagerCallable(this.client(0)){

            @Override
            public void call() {
                RemoteCache c3 = ClientClusterEventsTest.this.client(2).getCache();
                eventListener.expectNoEvents();
                c3.put((Object)1, (Object)"one");
                eventListener.expectOnlyCreatedEvent(1, ClientClusterEventsTest.this.cache(0));
                c3.put((Object)2, (Object)"two");
                eventListener.expectOnlyCreatedEvent(2, ClientClusterEventsTest.this.cache(0));
                c3.put((Object)3, (Object)"three");
                eventListener.expectOnlyCreatedEvent(3, ClientClusterEventsTest.this.cache(0));
                c3.replace((Object)1, (Object)"new-one");
                eventListener.expectOnlyModifiedEvent(1, ClientClusterEventsTest.this.cache(0));
                c3.replace((Object)2, (Object)"new-two");
                eventListener.expectOnlyModifiedEvent(2, ClientClusterEventsTest.this.cache(0));
                c3.replace((Object)3, (Object)"new-three");
                eventListener.expectOnlyModifiedEvent(3, ClientClusterEventsTest.this.cache(0));
                c3.remove((Object)1);
                eventListener.expectOnlyRemovedEvent(1, ClientClusterEventsTest.this.cache(0));
                c3.remove((Object)2);
                eventListener.expectOnlyRemovedEvent(2, ClientClusterEventsTest.this.cache(0));
                c3.remove((Object)3);
                eventListener.expectOnlyRemovedEvent(3, ClientClusterEventsTest.this.cache(0));
            }
        });
    }

    public void testFilteringInCluster() {
        final EventLogListener.StaticFilteredEventLogListener eventListener = new EventLogListener.StaticFilteredEventLogListener();
        HotRodClientTestingUtil.withClientListener(eventListener, new RemoteCacheManagerCallable(this.client(0)){

            @Override
            public void call() {
                RemoteCache c3 = ClientClusterEventsTest.this.client(2).getCache();
                eventListener.expectNoEvents();
                c3.put((Object)1, (Object)"one");
                eventListener.expectNoEvents();
                c3.put((Object)2, (Object)"two");
                eventListener.expectOnlyCreatedEvent(2, ClientClusterEventsTest.this.cache(0));
                c3.remove((Object)1);
                eventListener.expectNoEvents();
                c3.remove((Object)2);
                eventListener.expectOnlyRemovedEvent(2, ClientClusterEventsTest.this.cache(0));
            }
        });
    }

    public void testConversionInCluster() {
        final CustomEventLogListener.StaticCustomEventLogListener eventListener = new CustomEventLogListener.StaticCustomEventLogListener();
        HotRodClientTestingUtil.withClientListener(eventListener, new RemoteCacheManagerCallable(this.client(0)){

            @Override
            public void call() {
                RemoteCache c3 = ClientClusterEventsTest.this.client(2).getCache();
                eventListener.expectNoEvents();
                c3.put((Object)1, (Object)"one");
                eventListener.expectOnlyCreatedCustomEvent(new CustomEventLogListener.CustomEvent(1, "one"));
                c3.put((Object)2, (Object)"two");
                eventListener.expectOnlyCreatedCustomEvent(new CustomEventLogListener.CustomEvent(2, "two"));
                c3.remove((Object)1);
                eventListener.expectOnlyRemovedCustomEvent(new CustomEventLogListener.CustomEvent(1, null));
                c3.remove((Object)2);
                eventListener.expectOnlyRemovedCustomEvent(new CustomEventLogListener.CustomEvent(2, null));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEventReplayWithAndWithoutStateAfterFailover() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        HotRodServer server = this.server(0);
        builder.addServers(server.getHost() + ":" + server.getPort());
        builder.balancingStrategy(StickyServerLoadBalancingStrategy.class);
        RemoteCacheManager newClient = new RemoteCacheManager(builder.build());
        try {
            WithStateEventLogListener<Integer> statefulListener = new WithStateEventLogListener<Integer>();
            EventLogListener<Integer> statelessListener = new EventLogListener<Integer>();
            FailoverEventLogListener<Integer> failoverListener = new FailoverEventLogListener<Integer>();
            RemoteCache c = newClient.getCache();
            c.put((Object)0, (Object)"zero");
            c.remove((Object)0);
            c.addClientListener(statelessListener);
            c.addClientListener(statefulListener);
            c.addClientListener(failoverListener);
            c.put((Object)1, (Object)"one");
            statefulListener.expectOnlyCreatedEvent(1, this.cache(0));
            statelessListener.expectOnlyCreatedEvent(1, this.cache(0));
            failoverListener.expectOnlyCreatedEvent(1, this.cache(0));
            HotRodClientTestingUtil.findServerAndKill(newClient, this.servers, this.cacheManagers);
            c.put((Object)2, (Object)"two");
            statelessListener.expectNoEvents();
            statefulListener.expectFailoverEvent();
            failoverListener.expectFailoverEvent();
            statelessListener.expectNoEvents();
            failoverListener.expectNoEvents();
            statefulListener.expectUnorderedEvents(ClientEvent.Type.CLIENT_CACHE_ENTRY_CREATED, 1, 2);
            c.put((Object)3, (Object)"three");
            statefulListener.expectUnorderedEvents(ClientEvent.Type.CLIENT_CACHE_ENTRY_CREATED, 3);
            c.remove((Object)1);
            c.remove((Object)2);
            c.remove((Object)3);
        }
        finally {
            HotRodClientTestingUtil.killRemoteCacheManager(newClient);
        }
    }

    @ClientListener(includeCurrentState=true)
    public static class WithStateEventLogListener<K>
    extends FailoverEventLogListener<K> {
    }
}

