/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.event;

import java.io.Serializable;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryCreated;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryModified;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryRemoved;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.event.ClientCacheEntryCustomEvent;
import org.infinispan.client.hotrod.event.ClientEvent;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.cachelistener.filter.CacheEventConverter;
import org.infinispan.notifications.cachelistener.filter.CacheEventConverterFactory;
import org.infinispan.notifications.cachelistener.filter.EventType;
import org.infinispan.notifications.cachelistener.filter.NamedFactory;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;

@ClientListener(converterFactoryName="test-converter-factory")
public abstract class CustomEventLogListener<E> {
    BlockingQueue<E> createdCustomEvents = new ArrayBlockingQueue(128);
    BlockingQueue<E> modifiedCustomEvents = new ArrayBlockingQueue(128);
    BlockingQueue<E> removedCustomEvents = new ArrayBlockingQueue(128);

    public E pollEvent(ClientEvent.Type type) {
        try {
            E event = this.queue(type).poll(10L, TimeUnit.SECONDS);
            AssertJUnit.assertNotNull(event);
            return event;
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
    }

    protected BlockingQueue<E> queue(ClientEvent.Type type) {
        switch (type) {
            case CLIENT_CACHE_ENTRY_CREATED: {
                return this.createdCustomEvents;
            }
            case CLIENT_CACHE_ENTRY_MODIFIED: {
                return this.modifiedCustomEvents;
            }
            case CLIENT_CACHE_ENTRY_REMOVED: {
                return this.removedCustomEvents;
            }
        }
        throw new IllegalArgumentException("Unknown event type: " + type);
    }

    public void expectNoEvents(ClientEvent.Type type) {
        AssertJUnit.assertEquals((int)0, (int)this.queue(type).size());
    }

    public void expectNoEvents() {
        this.expectNoEvents(ClientEvent.Type.CLIENT_CACHE_ENTRY_CREATED);
        this.expectNoEvents(ClientEvent.Type.CLIENT_CACHE_ENTRY_MODIFIED);
        this.expectNoEvents(ClientEvent.Type.CLIENT_CACHE_ENTRY_REMOVED);
    }

    public void expectSingleCustomEvent(ClientEvent.Type type, E expected) {
        E event = this.pollEvent(type);
        TestingUtil.assertAnyEquals(expected, event);
    }

    public void expectOnlyCreatedCustomEvent(E expected) {
        this.expectSingleCustomEvent(ClientEvent.Type.CLIENT_CACHE_ENTRY_CREATED, expected);
        this.expectNoEvents(ClientEvent.Type.CLIENT_CACHE_ENTRY_MODIFIED);
        this.expectNoEvents(ClientEvent.Type.CLIENT_CACHE_ENTRY_REMOVED);
    }

    public void expectOnlyModifiedCustomEvent(E expected) {
        this.expectSingleCustomEvent(ClientEvent.Type.CLIENT_CACHE_ENTRY_MODIFIED, expected);
        this.expectNoEvents(ClientEvent.Type.CLIENT_CACHE_ENTRY_CREATED);
        this.expectNoEvents(ClientEvent.Type.CLIENT_CACHE_ENTRY_REMOVED);
    }

    public void expectOnlyRemovedCustomEvent(E expected) {
        this.expectSingleCustomEvent(ClientEvent.Type.CLIENT_CACHE_ENTRY_REMOVED, expected);
        this.expectNoEvents(ClientEvent.Type.CLIENT_CACHE_ENTRY_CREATED);
        this.expectNoEvents(ClientEvent.Type.CLIENT_CACHE_ENTRY_MODIFIED);
    }

    @ClientCacheEntryCreated
    public void handleCustomCreatedEvent(ClientCacheEntryCustomEvent<E> e) {
        AssertJUnit.assertEquals((Object)ClientEvent.Type.CLIENT_CACHE_ENTRY_CREATED, (Object)e.getType());
        this.createdCustomEvents.add(e.getEventData());
    }

    @ClientCacheEntryModified
    public void handleCustomModifiedEvent(ClientCacheEntryCustomEvent<E> e) {
        AssertJUnit.assertEquals((Object)ClientEvent.Type.CLIENT_CACHE_ENTRY_MODIFIED, (Object)e.getType());
        this.modifiedCustomEvents.add(e.getEventData());
    }

    @ClientCacheEntryRemoved
    public void handleCustomRemovedEvent(ClientCacheEntryCustomEvent<E> e) {
        AssertJUnit.assertEquals((Object)ClientEvent.Type.CLIENT_CACHE_ENTRY_REMOVED, (Object)e.getType());
        this.removedCustomEvents.add(e.getEventData());
    }

    static byte[] concat(byte[] a, byte[] b) {
        int aLen = a.length;
        int bLen = b.length;
        byte[] ret = new byte[aLen + bLen];
        System.arraycopy(a, 0, ret, 0, aLen);
        System.arraycopy(b, 0, ret, aLen, bLen);
        return ret;
    }

    @NamedFactory(name="raw-static-converter-factory")
    public static class RawStaticConverterFactory
    implements CacheEventConverterFactory {
        public CacheEventConverter<byte[], byte[], byte[]> getConverter(Object[] params) {
            return new RawStaticConverter();
        }

        static class RawStaticConverter
        implements CacheEventConverter<byte[], byte[], byte[]>,
        Serializable {
            RawStaticConverter() {
            }

            public byte[] convert(byte[] key, byte[] previousValue, Metadata previousMetadata, byte[] value, Metadata metadata, EventType eventType) {
                return value != null ? CustomEventLogListener.concat(key, value) : key;
            }
        }
    }

    @NamedFactory(name="dynamic-converter-factory")
    public static class DynamicConverterFactory
    implements CacheEventConverterFactory {
        public CacheEventConverter<Integer, String, CustomEvent> getConverter(Object[] params) {
            return new DynamicConverter(params);
        }

        static class DynamicConverter
        implements CacheEventConverter<Integer, String, CustomEvent>,
        Serializable {
            private final Object[] params;

            public DynamicConverter(Object[] params) {
                this.params = params;
            }

            public CustomEvent convert(Integer key, String previousValue, Metadata previousMetadata, String value, Metadata metadata, EventType eventType) {
                if (this.params[0].equals(key)) {
                    return new CustomEvent(key, null);
                }
                return new CustomEvent(key, value);
            }
        }
    }

    @NamedFactory(name="static-converter-factory")
    public static class StaticConverterFactory
    implements CacheEventConverterFactory {
        public CacheEventConverter<Integer, String, CustomEvent> getConverter(Object[] params) {
            return new StaticConverter();
        }

        static class StaticConverter
        implements CacheEventConverter<Integer, String, CustomEvent>,
        Serializable {
            StaticConverter() {
            }

            public CustomEvent convert(Integer key, String previousValue, Metadata previousMetadata, String value, Metadata metadata, EventType eventType) {
                return new CustomEvent(key, value);
            }
        }
    }

    @ClientListener(converterFactoryName="dynamic-converter-factory", includeCurrentState=true)
    public static class DynamicCustomEventWithStateLogListener
    extends CustomEventLogListener<CustomEvent> {
    }

    @ClientListener(converterFactoryName="dynamic-converter-factory")
    public static class DynamicCustomEventLogListener
    extends CustomEventLogListener<CustomEvent> {
    }

    @ClientListener(converterFactoryName="static-converter-factory", includeCurrentState=true)
    public static class StaticCustomEventLogWithStateListener
    extends CustomEventLogListener<CustomEvent> {
    }

    @ClientListener(converterFactoryName="raw-static-converter-factory", useRawData=true)
    public static class RawStaticCustomEventLogListener
    extends CustomEventLogListener<byte[]> {
    }

    @ClientListener(converterFactoryName="static-converter-factory")
    public static class StaticCustomEventLogListener
    extends CustomEventLogListener<CustomEvent> {
        @Override
        public void expectSingleCustomEvent(ClientEvent.Type type, CustomEvent expected) {
            CustomEvent event = (CustomEvent)this.pollEvent(type);
            AssertJUnit.assertNotNull((Object)event.key);
            AssertJUnit.assertNotNull((Object)event.timestamp);
            TestingUtil.assertAnyEquals((Object)expected, (Object)event);
        }

        public void expectOrderedEventQueue(ClientEvent.Type type) {
            BlockingQueue queue = this.queue(type);
            if (queue.size() < 2) {
                return;
            }
            try {
                CustomEvent before = (CustomEvent)queue.poll(10L, TimeUnit.SECONDS);
                for (CustomEvent after : queue) {
                    this.expectTimeOrdered(before, after);
                    before = after;
                }
            }
            catch (InterruptedException e) {
                throw new AssertionError((Object)e);
            }
        }

        private void expectTimeOrdered(CustomEvent before, CustomEvent after) {
            AssertJUnit.assertTrue((String)("Before timestamp=" + before.timestamp + ", after timestamp=" + after.timestamp), (before.timestamp < after.timestamp ? 1 : 0) != 0);
        }
    }

    public static final class CustomEvent
    implements Serializable {
        final Integer key;
        final String value;
        final long timestamp;

        public CustomEvent(Integer key, String value) {
            this.key = key;
            this.value = value;
            this.timestamp = System.nanoTime();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CustomEvent that = (CustomEvent)o;
            if (!this.key.equals(that.key)) {
                return false;
            }
            return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
        }

        public int hashCode() {
            int result = this.key.hashCode();
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            return result;
        }
    }
}

