/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.event;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.net.ServerSocket;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.event.ClientListenerNotifier;
import org.infinispan.client.hotrod.event.EventLogListener;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.event.ListenerStopTest")
public class ListenerCacheManagerStopTest
extends AbstractInfinispanTest {
    HotRodServer hotRodServer;
    RemoteCacheManager remoteCacheManager;
    RemoteCache<Integer, String> cache;
    EmbeddedCacheManager cacheManager;

    @BeforeMethod
    public void setup() throws IOException {
        Integer port = this.getRandomFreePort();
        this.cacheManager = TestCacheManagerFactory.createCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration());
        this.hotRodServer = HotRodTestingUtil.startHotRodServer((EmbeddedCacheManager)this.cacheManager, (int)port);
        this.remoteCacheManager = new RemoteCacheManager(new ConfigurationBuilder().addServer().port(port.intValue()).host(HotRodTestingUtil.host()).connectionTimeout(3000).socketTimeout(3000).build());
        this.cache = this.remoteCacheManager.getCache();
    }

    @AfterMethod
    public void tearDown() {
        HotRodClientTestingUtil.killServers(this.hotRodServer);
        HotRodClientTestingUtil.killRemoteCacheManager(this.remoteCacheManager);
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.cacheManager});
    }

    @Test
    public void testThreadsAreStopped() throws Exception {
        EventLogListener listener = new EventLogListener();
        this.cache.addClientListener(listener);
        String listenerId = this.findListenerId(listener);
        this.assertListenerThreadRunning(listenerId);
        this.remoteCacheManager.stop();
        this.hotRodServer.stop();
        this.assertListenerThreadNotRunning(listenerId);
    }

    private String findListenerId(Object listener) {
        ClientListenerNotifier clientNotifier = (ClientListenerNotifier)TestingUtil.extractField((Object)this.remoteCacheManager, (String)"listenerNotifier");
        return Util.toHexString((byte[])clientNotifier.findListenerId(listener), (int)8);
    }

    private void assertListenerThreadRunning(final String listenerId) {
        this.eventually(new AbstractInfinispanTest.Condition(){

            public boolean isSatisfied() throws Exception {
                return ListenerCacheManagerStopTest.this.isListenerThreadRunning(listenerId);
            }
        });
    }

    private void assertListenerThreadNotRunning(final String listenerId) {
        this.eventually(new AbstractInfinispanTest.Condition(){

            public boolean isSatisfied() throws Exception {
                return !ListenerCacheManagerStopTest.this.isListenerThreadRunning(listenerId);
            }
        });
    }

    private boolean isListenerThreadRunning(String listenerId) {
        ThreadInfo[] threadInfos;
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        for (ThreadInfo threadInfo : threadInfos = threadMXBean.dumpAllThreads(false, false)) {
            if (!threadInfo.getThreadState().equals((Object)Thread.State.RUNNABLE) && !threadInfo.getThreadState().equals((Object)Thread.State.BLOCKED) || !threadInfo.getThreadName().contains(listenerId)) continue;
            return true;
        }
        return false;
    }

    private Integer getRandomFreePort() throws IOException {
        try (ServerSocket socket = new ServerSocket(0);){
            Integer n = socket.getLocalPort();
            return n;
        }
    }
}

