/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.event;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.Search;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryCreated;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryModified;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryRemoved;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.event.ClientCacheEntryCustomEvent;
import org.infinispan.client.hotrod.event.ClientCacheEntryModifiedEvent;
import org.infinispan.client.hotrod.event.ClientCacheEntryRemovedEvent;
import org.infinispan.client.hotrod.event.ClientEvents;
import org.infinispan.client.hotrod.marshall.ProtoStreamMarshaller;
import org.infinispan.client.hotrod.query.testdomain.protobuf.AddressPB;
import org.infinispan.client.hotrod.query.testdomain.protobuf.UserPB;
import org.infinispan.client.hotrod.query.testdomain.protobuf.marshallers.MarshallerRegistration;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.notifications.cachelistener.filter.CacheEventConverterFactory;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilterFactory;
import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.embedded.testdomain.User;
import org.infinispan.query.remote.client.FilterResult;
import org.infinispan.query.remote.filter.JPACacheEventFilterConverterFactory;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.junit.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.event.RemoteListenerWithDslFilterTest")
public class RemoteListenerWithDslFilterTest
extends MultiHotRodServersTest {
    private final int NUM_NODES = 5;
    private RemoteCache<Object, Object> remoteCache;

    protected void createCacheManagers() throws Throwable {
        org.infinispan.configuration.cache.ConfigurationBuilder cfgBuilder = HotRodTestingUtil.hotRodCacheConfiguration((org.infinispan.configuration.cache.ConfigurationBuilder)RemoteListenerWithDslFilterTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false));
        this.createHotRodServers(5, cfgBuilder);
        this.waitForClusterToForm();
        JPACacheEventFilterConverterFactory factory = new JPACacheEventFilterConverterFactory();
        this.server(0).addCacheEventFilterFactory("query-dsl-filter-converter-factory", (CacheEventFilterFactory)factory);
        this.server(0).addCacheEventConverterFactory("query-dsl-filter-converter-factory", (CacheEventConverterFactory)factory);
        this.remoteCache = this.client(0).getCache();
        RemoteCache metadataCache = this.client(0).getCache("___protobuf_metadata");
        metadataCache.put((Object)"sample_bank_account/bank.proto", (Object)Util.read((InputStream)Util.getResourceAsStream((String)"/sample_bank_account/bank.proto", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader())));
        Assert.assertFalse((boolean)metadataCache.containsKey((Object)".errors"));
        MarshallerRegistration.registerMarshallers(ProtoStreamMarshaller.getSerializationContext((RemoteCacheManager)this.client(0)));
    }

    @Override
    protected ConfigurationBuilder createHotRodClientConfigurationBuilder(int serverPort) {
        return super.createHotRodClientConfigurationBuilder(serverPort).marshaller((Marshaller)new ProtoStreamMarshaller());
    }

    public void testEventFilter() throws Exception {
        UserPB user1 = new UserPB();
        user1.setId(1);
        user1.setName("John");
        user1.setSurname("Doe");
        user1.setGender(User.Gender.MALE);
        user1.setAge(22);
        user1.setAccountIds(new HashSet<Integer>(Arrays.asList(1, 2)));
        user1.setNotes("Lorem ipsum dolor sit amet");
        AddressPB address1 = new AddressPB();
        address1.setStreet("Main Street");
        address1.setPostCode("X1234");
        user1.setAddresses(Collections.singletonList(address1));
        UserPB user2 = new UserPB();
        user2.setId(2);
        user2.setName("Spider");
        user2.setSurname("Man");
        user2.setGender(User.Gender.MALE);
        user2.setAge(32);
        user2.setAccountIds(Collections.singleton(3));
        AddressPB address2 = new AddressPB();
        address2.setStreet("Old Street");
        address2.setPostCode("Y12");
        AddressPB address3 = new AddressPB();
        address3.setStreet("Bond Street");
        address3.setPostCode("ZZ");
        user2.setAddresses(Arrays.asList(address2, address3));
        UserPB user3 = new UserPB();
        user3.setId(3);
        user3.setName("Spider");
        user3.setSurname("Woman");
        user3.setGender(User.Gender.FEMALE);
        user3.setAge(40);
        user3.setAccountIds(Collections.emptySet());
        SerializationContext serCtx = ProtoStreamMarshaller.getSerializationContext((RemoteCacheManager)this.client(0));
        QueryFactory qf = Search.getQueryFactory(this.remoteCache);
        Query query = qf.from(UserPB.class).having("age").lte((Object)32).toBuilder().setProjection(new String[]{"age"}).build();
        ClientEntryListener listener = new ClientEntryListener(serCtx);
        ClientEvents.addClientQueryListener(this.remoteCache, (Object)listener, (Query)query);
        this.remoteCache.put((Object)("user_" + user1.getId()), (Object)user1);
        this.remoteCache.put((Object)("user_" + user2.getId()), (Object)user2);
        this.remoteCache.put((Object)("user_" + user3.getId()), (Object)user3);
        Assert.assertEquals((long)3L, (long)this.remoteCache.size());
        Assert.assertEquals((long)2L, (long)listener.createEvents.size());
        this.remoteCache.removeClientListener((Object)listener);
    }

    @ClientListener(filterFactoryName="query-dsl-filter-converter-factory", converterFactoryName="query-dsl-filter-converter-factory", useRawData=true, includeCurrentState=true)
    public class ClientEntryListener {
        public final List<FilterResult> createEvents = new ArrayList<FilterResult>();
        private final SerializationContext serializationContext;

        public ClientEntryListener(SerializationContext serializationContext) {
            this.serializationContext = serializationContext;
        }

        @ClientCacheEntryCreated
        public void handleClientCacheEntryCreatedEvent(ClientCacheEntryCustomEvent event) throws IOException {
            FilterResult r = (FilterResult)ProtobufUtil.fromWrappedByteArray((SerializationContext)this.serializationContext, (byte[])((byte[])event.getEventData()));
            this.createEvents.add(r);
            RemoteListenerWithDslFilterTest.this.log.debugf("handleClientCacheEntryCreatedEvent instance=%s projection=%s sortProjection=%s\n", r.getInstance(), r.getProjection() == null ? null : Arrays.asList(r.getProjection()), r.getSortProjection() == null ? null : Arrays.asList(r.getSortProjection()));
        }

        @ClientCacheEntryModified
        public void handleClientCacheEntryModifiedEvent(ClientCacheEntryModifiedEvent event) {
            RemoteListenerWithDslFilterTest.this.log.debugf("handleClientCacheEntryModifiedEvent %s\n", event.getKey());
        }

        @ClientCacheEntryRemoved
        public void handleClientCacheEntryRemovedEvent(ClientCacheEntryRemovedEvent event) {
            RemoteListenerWithDslFilterTest.this.log.debugf("handleClientCacheEntryRemovedEvent %s\n", event.getKey());
        }
    }
}

