/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.near;

import org.infinispan.client.hotrod.configuration.NearCacheMode;
import org.infinispan.client.hotrod.near.AssertsNearCache;
import org.infinispan.client.hotrod.near.EagerFailoverNearCacheTest;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.near.LazyFailoverNearCacheTest")
public class LazyFailoverNearCacheTest
extends EagerFailoverNearCacheTest {
    @Override
    protected NearCacheMode getNearCacheMode() {
        return NearCacheMode.LAZY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testNearCacheClearedUponFailover() {
        AssertsNearCache<Integer, String> stickyClient = this.createStickyAssertClient();
        try {
            stickyClient.put(1, "v1").expectNearRemove(1, this.headClient(), this.tailClient());
            stickyClient.get(1, "v1").expectNearGetNull(1).expectNearPutIfAbsent(1, "v1");
            stickyClient.put(2, "v1").expectNearRemove(2, this.headClient(), this.tailClient());
            stickyClient.get(2, "v1").expectNearGetNull(2).expectNearPutIfAbsent(2, "v1");
            stickyClient.put(3, "v1").expectNearRemove(3, this.headClient(), this.tailClient());
            stickyClient.get(3, "v1").expectNearGetNull(3).expectNearPutIfAbsent(3, "v1");
            HotRodClientTestingUtil.findServerAndKill(stickyClient.manager, this.servers, this.cacheManagers);
            stickyClient.get(1, "v1").expectNearClear(new AssertsNearCache[0]).expectNearPutIfAbsent(1, "v1");
            stickyClient.expectNoNearEvents();
            this.headClient().get(2, "v1").expectNearClear(new AssertsNearCache[0]).expectNearPutIfAbsent(2, "v1");
            this.headClient().expectNoNearEvents();
            this.tailClient().get(3, "v1").expectNearClear(new AssertsNearCache[0]).expectNearPutIfAbsent(3, "v1");
            this.tailClient().expectNoNearEvents();
        }
        finally {
            stickyClient.stop();
        }
    }
}

