/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.near;

import org.infinispan.client.hotrod.configuration.NearCacheMode;
import org.infinispan.client.hotrod.near.AssertsNearCache;
import org.infinispan.client.hotrod.near.EagerNearCacheTest;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.RemoteCacheManagerCallable;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.near.LazyNearCacheTest")
public class LazyNearCacheTest
extends EagerNearCacheTest {
    @Override
    protected NearCacheMode getNearCacheMode() {
        return NearCacheMode.LAZY;
    }

    @Override
    public void testGetNearCache() {
        this.assertClient.expectNoNearEvents();
        this.assertClient.get(1, null).expectNearGetNull(1);
        this.assertClient.put(1, "v1").expectNearRemove(1, new AssertsNearCache[0]);
        this.assertClient.get(1, "v1").expectNearGetNull(1).expectNearPutIfAbsent(1, "v1");
        this.assertClient.get(1, "v1").expectNearGetValue(1, "v1");
        this.assertClient.remove(1).expectNearRemove(1, new AssertsNearCache[0]);
        this.assertClient.get(1, null).expectNearGetNull(1);
    }

    @Override
    public void testGetVersionedNearCache() {
        this.assertClient.expectNoNearEvents();
        this.assertClient.getVersioned(1, null).expectNearGetNull(1);
        this.assertClient.put(1, "v1").expectNearRemove(1, new AssertsNearCache[0]);
        this.assertClient.getVersioned(1, "v1").expectNearGetNull(1).expectNearPutIfAbsent(1, "v1");
        this.assertClient.getVersioned(1, "v1").expectNearGetValueVersion(1, "v1");
        this.assertClient.remove(1).expectNearRemove(1, new AssertsNearCache[0]);
        this.assertClient.getVersioned(1, null).expectNearGetNull(1);
    }

    @Override
    public void testUpdateNearCache() {
        this.assertClient.expectNoNearEvents();
        this.assertClient.put(1, "v1").expectNearRemove(1, new AssertsNearCache[0]);
        this.assertClient.put(1, "v2").expectNearRemove(1, new AssertsNearCache[0]);
        this.assertClient.get(1, "v2").expectNearGetNull(1).expectNearPutIfAbsent(1, "v2");
        this.assertClient.get(1, "v2").expectNearGetValue(1, "v2");
        this.assertClient.put(1, "v3").expectNearRemove(1, new AssertsNearCache[0]);
        this.assertClient.remove(1).expectNearRemove(1, new AssertsNearCache[0]);
    }

    @Override
    public void testGetUpdatesNearCache() {
        this.assertClient.expectNoNearEvents();
        this.assertClient.put(1, "v1").expectNearRemove(1, new AssertsNearCache[0]);
        final AssertsNearCache newAsserts = this.createClient();
        HotRodClientTestingUtil.withRemoteCacheManager(new RemoteCacheManagerCallable(newAsserts.manager){

            @Override
            public void call() {
                newAsserts.expectNoNearEvents();
                newAsserts.get(1, "v1").expectNearGetNull(1).expectNearPutIfAbsent(1, "v1");
            }
        });
    }
}

