/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.query;

import java.util.List;
import org.hibernate.search.spi.SearchIntegrator;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.query.RemoteQueryDslConditionsTest;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.query.Search;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.embedded.testdomain.User;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.junit.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.query.RemoteNonIndexedQueryDslConditionsTest")
public class RemoteNonIndexedQueryDslConditionsTest
extends RemoteQueryDslConditionsTest {
    @Override
    protected ConfigurationBuilder getConfigurationBuilder() {
        return HotRodTestingUtil.hotRodCacheConfiguration();
    }

    @Override
    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Indexing was not enabled on this cache.*")
    public void testIndexPresence() {
        Search.getSearchManager(this.getEmbeddedCache()).unwrap(SearchIntegrator.class);
    }

    @Override
    @Test
    public void testEqNonIndexed() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("notes").eq((Object)"Lorem ipsum dolor sit amet").toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((User)list.get(0)).getId());
    }

    @Override
    @Test(expectedExceptions={HotRodClientException.class}, expectedExceptionsMessageRegExp=".*ISPN000405:.*")
    public void testInvalidEmbeddedAttributeQuery() throws Exception {
        super.testInvalidEmbeddedAttributeQuery();
    }

    @Test
    public void testNullOnIntegerField() throws Exception {
        super.testNullOnIntegerField();
    }
}

