/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.retry;

import java.net.SocketAddress;
import java.util.Properties;
import org.infinispan.AdvancedCache;
import org.infinispan.client.hotrod.HitsAwareCacheManagersTest;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.impl.RemoteCacheImpl;
import org.infinispan.client.hotrod.impl.transport.tcp.RoundRobinBalancingStrategy;
import org.infinispan.client.hotrod.impl.transport.tcp.TcpTransportFactory;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.InternalRemoteCacheManager;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.AfterMethod;

public abstract class AbstractRetryTest
extends HitsAwareCacheManagersTest {
    protected HotRodServer hotRodServer1;
    protected HotRodServer hotRodServer2;
    protected HotRodServer hotRodServer3;
    RemoteCacheImpl<Object, Object> remoteCache;
    protected RemoteCacheManager remoteCacheManager;
    protected TcpTransportFactory tcpTransportFactory;
    protected ConfigurationBuilder config;
    protected RoundRobinBalancingStrategy strategy;

    public AbstractRetryTest() {
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
    }

    protected void assertSupportedConfig() {
    }

    protected void createCacheManagers() throws Throwable {
        this.config = HotRodTestingUtil.hotRodCacheConfiguration((ConfigurationBuilder)this.getCacheConfig());
        EmbeddedCacheManager cm1 = TestCacheManagerFactory.createClusteredCacheManager((ConfigurationBuilder)this.config);
        EmbeddedCacheManager cm2 = TestCacheManagerFactory.createClusteredCacheManager((ConfigurationBuilder)this.config);
        EmbeddedCacheManager cm3 = TestCacheManagerFactory.createClusteredCacheManager((ConfigurationBuilder)this.config);
        this.registerCacheManager(new CacheContainer[]{cm1});
        this.registerCacheManager(new CacheContainer[]{cm2});
        this.registerCacheManager(new CacheContainer[]{cm3});
        this.hotRodServer1 = HotRodClientTestingUtil.startHotRodServer(this.manager(0));
        this.addr2hrServer.put(this.getAddress(this.hotRodServer1), this.hotRodServer1);
        this.hotRodServer2 = HotRodClientTestingUtil.startHotRodServer(this.manager(1));
        this.addr2hrServer.put(this.getAddress(this.hotRodServer2), this.hotRodServer2);
        this.hotRodServer3 = HotRodClientTestingUtil.startHotRodServer(this.manager(2));
        this.addr2hrServer.put(this.getAddress(this.hotRodServer3), this.hotRodServer3);
        this.waitForClusterToForm();
        Properties clientConfig = new Properties();
        clientConfig.put("infinispan.client.hotrod.server_list", "localhost:" + this.hotRodServer1.getPort());
        clientConfig.put("infinispan.client.hotrod.force_return_values", "true");
        clientConfig.put("infinispan.client.hotrod.connect_timeout", "5");
        clientConfig.put("maxActive", (Object)1);
        this.remoteCacheManager = new InternalRemoteCacheManager(clientConfig);
        this.remoteCache = (RemoteCacheImpl)this.remoteCacheManager.getCache();
        this.tcpTransportFactory = (TcpTransportFactory)((InternalRemoteCacheManager)this.remoteCacheManager).getTransportFactory();
        this.strategy = (RoundRobinBalancingStrategy)HotRodClientTestingUtil.getLoadBalancer(this.remoteCacheManager);
        this.addInterceptors();
        assert (this.cacheManagers.size() == 3);
    }

    @AfterMethod(alwaysRun=true)
    protected void clearContent() throws Throwable {
        if (this.cleanupAfterMethod()) {
            HotRodClientTestingUtil.killRemoteCacheManagers(this.remoteCacheManager);
            HotRodClientTestingUtil.killServers(this.hotRodServer1, this.hotRodServer2, this.hotRodServer3);
        }
        super.clearContent();
    }

    protected abstract ConfigurationBuilder getCacheConfig();

    protected AdvancedCache<?, ?> nextCacheToHit() {
        SocketAddress expectedServer = this.strategy.getServers()[this.strategy.getNextPosition()];
        return ((HotRodServer)this.addr2hrServer.get(expectedServer)).getCacheManager().getCache().getAdvancedCache();
    }
}

