/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.retry;

import java.net.SocketAddress;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.exceptions.RemoteNodeSuspectException;
import org.infinispan.client.hotrod.exceptions.TransportException;
import org.infinispan.client.hotrod.impl.operations.RetryOnFailureOperation;
import org.infinispan.client.hotrod.impl.transport.Transport;
import org.infinispan.client.hotrod.impl.transport.TransportFactory;
import org.mockito.Mockito;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="client.hotrod.retry.RetryOnFailureUnitTest")
public class RetryOnFailureUnitTest {
    public void testNoRetryOnTransportFailure() {
        this.doRetryTest(0, true);
    }

    public void testNoRetryOnExecuteFailure() {
        this.doRetryTest(0, false);
    }

    public void testSingleRetryOnTransportFailure() {
        this.doRetryTest(1, true);
    }

    public void testSingleRetryOnExecuteFailure() {
        this.doRetryTest(1, false);
    }

    public void testMultipleRetryOnTransportFailure() {
        this.doRetryTest(10, true);
    }

    public void testMultipleRetryOnExecuteFailure() {
        this.doRetryTest(10, false);
    }

    private void doRetryTest(int maxRetry, boolean failOnTransport) {
        TransportFactory mockTransport = (TransportFactory)Mockito.mock(TransportFactory.class);
        Mockito.when((Object)mockTransport.getMaxRetries()).thenReturn((Object)maxRetry);
        MockOperation mockOperation = new MockOperation(mockTransport, failOnTransport);
        try {
            mockOperation.execute();
            AssertJUnit.fail((String)"Exception expected!");
        }
        catch (HotRodClientException expected) {
            // empty catch block
        }
        if (failOnTransport) {
            AssertJUnit.assertEquals((String)"Wrong getTransport() invocation.", (int)((maxRetry + 1) * 2), (int)mockOperation.transportInvocationCount.get());
            AssertJUnit.assertEquals((String)"Wrong execute() invocation.", (int)0, (int)mockOperation.executeInvocationCount.get());
        } else {
            AssertJUnit.assertEquals((String)"Wrong getTransport() invocation.", (int)(maxRetry + 1), (int)mockOperation.transportInvocationCount.get());
            AssertJUnit.assertEquals((String)"Wrong execute() invocation.", (int)(maxRetry + 1), (int)mockOperation.executeInvocationCount.get());
        }
    }

    private class MockOperation
    extends RetryOnFailureOperation<Void> {
        private final AtomicInteger transportInvocationCount;
        private final AtomicInteger executeInvocationCount;
        private final boolean failOnTransport;

        public MockOperation(TransportFactory transportFactory, boolean failOnTransport) {
            super(null, transportFactory, null, null, null);
            this.failOnTransport = failOnTransport;
            this.transportInvocationCount = new AtomicInteger(0);
            this.executeInvocationCount = new AtomicInteger(0);
        }

        protected Transport getTransport(int retryCount, Set<SocketAddress> failedServers) {
            this.transportInvocationCount.incrementAndGet();
            if (this.failOnTransport) {
                throw new TransportException("Induced Failure", null);
            }
            return null;
        }

        protected Void executeOperation(Transport transport) {
            this.executeInvocationCount.incrementAndGet();
            if (!this.failOnTransport) {
                throw new RemoteNodeSuspectException("Induced Failure", 1L, 1);
            }
            return null;
        }
    }
}

