/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.iteration;

import java.util.BitSet;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.stream.IntStream;
import org.infinispan.client.hotrod.impl.consistenthash.SegmentConsistentHash;
import org.infinispan.client.hotrod.impl.iteration.KeyTracker;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.commons.equivalence.ByteArrayEquivalence;
import org.infinispan.commons.equivalence.Equivalence;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.commons.util.Util;

public class SegmentKeyTracker
implements KeyTracker {
    private static final Log log = LogFactory.getLog(SegmentKeyTracker.class);
    private final AtomicReferenceArray<Set<byte[]>> keysPerSegment;
    private final SegmentConsistentHash segmentConsistentHash;

    public SegmentKeyTracker(SegmentConsistentHash segmentConsistentHash) {
        int numSegments = segmentConsistentHash.getNumSegments();
        this.keysPerSegment = new AtomicReferenceArray(numSegments);
        if (log.isDebugEnabled()) {
            log.debugf("Created SegmentKeyTracker with %d segments", numSegments);
        }
        this.segmentConsistentHash = segmentConsistentHash;
        IntStream.range(0, segmentConsistentHash.getNumSegments()).forEach(i -> this.keysPerSegment.set(i, CollectionFactory.makeSet((Equivalence)ByteArrayEquivalence.INSTANCE)));
    }

    @Override
    public boolean track(byte[] key) {
        int segment = this.segmentConsistentHash.getSegment(key);
        boolean result = this.keysPerSegment.get(segment).add(key);
        if (log.isDebugEnabled()) {
            log.debugf("Tracking key %s belonging to segment %d, seenBefore? = %s", Util.printArray((byte[])key), segment, !result);
        }
        return result;
    }

    @Override
    public Set<Integer> missedSegments() {
        HashSet<Integer> missed = new HashSet<Integer>(this.keysPerSegment.length());
        for (int i = 0; i < this.keysPerSegment.length(); ++i) {
            if (this.keysPerSegment.get(i) == null) continue;
            missed.add(i);
        }
        return missed;
    }

    @Override
    public void segmentsFinished(byte[] finishedSegments) {
        if (finishedSegments != null) {
            BitSet bitSet = BitSet.valueOf(finishedSegments);
            if (log.isDebugEnabled()) {
                log.debugf("Removing completed segments %s", bitSet);
            }
            bitSet.stream().forEach(seg -> this.keysPerSegment.set(seg, null));
        }
    }
}

