/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.DistTopologyChangeUnderLoadSingleOwnerTest")
public class DistTopologyChangeUnderLoadSingleOwnerTest
extends MultiHotRodServersTest {
    protected void createCacheManagers() throws Throwable {
        this.createHotRodServers(2, this.getCacheConfiguration());
    }

    private ConfigurationBuilder getCacheConfiguration() {
        ConfigurationBuilder builder = DistTopologyChangeUnderLoadSingleOwnerTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false);
        builder.clustering().hash().numOwners(1);
        return HotRodTestingUtil.hotRodCacheConfiguration((ConfigurationBuilder)builder);
    }

    @Override
    protected int maxRetries() {
        return 1;
    }

    public void testRestartServerWhilePutting() throws Exception {
        RemoteCache remote = this.client(0).getCache();
        remote.put((Object)1, (Object)"v1");
        AssertJUnit.assertEquals((String)"v1", (String)((String)remote.get((Object)1)));
        PutHammer putHammer = new PutHammer();
        Future putHammerFuture = this.fork(putHammer);
        HotRodServer toKillServer = (HotRodServer)this.servers.get(0);
        HotRodClientTestingUtil.killServers(toKillServer);
        this.servers.remove(toKillServer);
        EmbeddedCacheManager toKillCacheManager = (EmbeddedCacheManager)this.cacheManagers.get(0);
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{toKillCacheManager});
        this.cacheManagers.remove(toKillCacheManager);
        TestingUtil.waitForRehashToComplete((Cache[])new Cache[]{this.cache(0)});
        EmbeddedCacheManager cm = TestCacheManagerFactory.createClusteredCacheManager((ConfigurationBuilder)this.getCacheConfiguration());
        this.registerCacheManager(new CacheContainer[]{cm});
        HotRodClientTestingUtil.startHotRodServer(cm);
        this.waitForClusterToForm();
        TestingUtil.waitForRehashToComplete((Cache[])new Cache[]{cm.getCache(), this.cache(0)});
        putHammer.stop = true;
        putHammerFuture.get();
    }

    private class PutHammer
    implements Callable<Void> {
        private final Random r = new Random();
        volatile boolean stop;

        private PutHammer() {
        }

        @Override
        public Void call() throws Exception {
            RemoteCache remote = DistTopologyChangeUnderLoadSingleOwnerTest.this.client(0).getCache();
            while (!this.stop) {
                int i = this.r.nextInt(10);
                remote.put((Object)i, (Object)("v" + i));
            }
            return null;
        }
    }
}

