/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.util.Properties;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.ForceReturnValuesTest", groups={"functional"})
@CleanupAfterMethod
public class ForceReturnValuesTest
extends SingleCacheManagerTest {
    private HotRodServer hotRodServer;
    private RemoteCacheManager remoteCacheManager;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        this.cacheManager = TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration());
        this.cache = this.cacheManager.getCache();
        this.hotRodServer = HotRodClientTestingUtil.startHotRodServer(this.cacheManager);
        Properties hotrodClientConf = new Properties();
        hotrodClientConf.put("infinispan.client.hotrod.server_list", "localhost:" + this.hotRodServer.getPort());
        this.remoteCacheManager = new RemoteCacheManager(hotrodClientConf);
        return this.cacheManager;
    }

    @AfterMethod
    void shutdown() {
        HotRodClientTestingUtil.killRemoteCacheManager(this.remoteCacheManager);
        HotRodClientTestingUtil.killServers(this.hotRodServer);
    }

    public void testDontForceReturnValues() {
        RemoteCache rc = this.remoteCacheManager.getCache();
        String rv = (String)rc.put((Object)"Key", (Object)"Value");
        assert (rv == null);
        rv = (String)rc.put((Object)"Key", (Object)"Value2");
        assert (rv == null);
    }

    public void testForceReturnValues() {
        RemoteCache rc = this.remoteCacheManager.getCache(true);
        String rv = (String)rc.put((Object)"Key", (Object)"Value");
        assert (rv == null);
        rv = (String)rc.put((Object)"Key", (Object)"Value2");
        assert (rv != null);
        assert ("Value".equals(rv));
    }

    public void testSameInstanceForSameForceReturnValues() {
        RemoteCache rcDontForceReturn = this.remoteCacheManager.getCache(false);
        RemoteCache rcDontForceReturn2 = this.remoteCacheManager.getCache(false);
        AssertJUnit.assertSame((String)"RemoteCache instances should be the same", (Object)rcDontForceReturn, (Object)rcDontForceReturn2);
        RemoteCache rcForceReturn = this.remoteCacheManager.getCache(true);
        RemoteCache rcForceReturn2 = this.remoteCacheManager.getCache(true);
        AssertJUnit.assertSame((String)"RemoteCache instances should be the same", (Object)rcForceReturn, (Object)rcForceReturn2);
    }

    public void testDifferentInstancesForDifferentForceReturnValues() {
        RemoteCache rcDontForceReturn = this.remoteCacheManager.getCache(false);
        RemoteCache rcForceReturn = this.remoteCacheManager.getCache(true);
        AssertJUnit.assertNotSame((String)"RemoteCache instances should not be the same", (Object)rcDontForceReturn, (Object)rcForceReturn);
        String rv = (String)rcDontForceReturn.put((Object)"Key", (Object)"Value");
        AssertJUnit.assertNull((Object)rv);
        rv = (String)rcDontForceReturn.put((Object)"Key", (Object)"Value2");
        AssertJUnit.assertNull((Object)rv);
        rv = (String)rcForceReturn.put((Object)"Key2", (Object)"Value");
        AssertJUnit.assertNull((Object)rv);
        rv = (String)rcForceReturn.put((Object)"Key2", (Object)"Value2");
        AssertJUnit.assertNotNull((Object)rv);
        AssertJUnit.assertEquals((String)"Previous value should be 'Value'", (String)"Value", (String)rv);
    }
}

