/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.event;

import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.event.CustomEventLogListener;
import org.infinispan.client.hotrod.event.EventLogListener;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.client.hotrod.test.RemoteCacheManagerCallable;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.cachelistener.filter.CacheEventConverterFactory;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilterConverterFactory;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilterFactory;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.event.ClientClusterEventsTest")
public class ClientClusterEventsTest
extends MultiHotRodServersTest {
    static final int NUM_SERVERS = 2;

    protected void createCacheManagers() throws Throwable {
        this.createHotRodServers(2, this.getCacheConfiguration());
    }

    private ConfigurationBuilder getCacheConfiguration() {
        ConfigurationBuilder builder = ClientClusterEventsTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false);
        builder.clustering().hash().numOwners(1);
        return HotRodTestingUtil.hotRodCacheConfiguration((ConfigurationBuilder)builder);
    }

    @Override
    protected HotRodServer addHotRodServer(ConfigurationBuilder builder) {
        EmbeddedCacheManager cm = this.addClusterEnabledCacheManager(builder);
        HotRodServerConfigurationBuilder serverBuilder = new HotRodServerConfigurationBuilder();
        HotRodServer server = HotRodClientTestingUtil.startHotRodServer(cm, serverBuilder);
        server.addCacheEventConverterFactory("static-converter-factory", (CacheEventConverterFactory)new CustomEventLogListener.StaticConverterFactory());
        server.addCacheEventFilterConverterFactory("filter-converter-factory", (CacheEventFilterConverterFactory)new CustomEventLogListener.FilterConverterFactory());
        this.servers.add(server);
        return server;
    }

    public void testEventForwarding() {
        final Integer key0 = HotRodClientTestingUtil.getIntKeyForServer(this.server(0));
        final Integer key1 = HotRodClientTestingUtil.getIntKeyForServer(this.server(1));
        final EventLogListener eventListener = new EventLogListener();
        HotRodClientTestingUtil.withClientListener(eventListener, new RemoteCacheManagerCallable(this.client(0)){

            @Override
            public void call() {
                RemoteCache remote = ClientClusterEventsTest.this.client(0).getCache();
                eventListener.expectNoEvents();
                remote.put((Object)key0, (Object)"one");
                eventListener.expectOnlyCreatedEvent(key0, ClientClusterEventsTest.this.cache(0));
                remote.put((Object)key1, (Object)"two");
                eventListener.expectOnlyCreatedEvent(key1, ClientClusterEventsTest.this.cache(0));
                remote.replace((Object)key0, (Object)"new-one");
                eventListener.expectOnlyModifiedEvent(key0, ClientClusterEventsTest.this.cache(0));
                remote.replace((Object)key1, (Object)"new-two");
                eventListener.expectOnlyModifiedEvent(key1, ClientClusterEventsTest.this.cache(0));
                remote.remove((Object)key0);
                eventListener.expectOnlyRemovedEvent(key0, ClientClusterEventsTest.this.cache(0));
                remote.remove((Object)key1);
                eventListener.expectOnlyRemovedEvent(key1, ClientClusterEventsTest.this.cache(0));
            }
        });
    }

    public void testFilteringInCluster() {
        final Integer key0 = HotRodClientTestingUtil.getIntKeyForServer(this.server(0));
        final Integer key1 = HotRodClientTestingUtil.getIntKeyForServer(this.server(1));
        for (HotRodServer server : this.servers) {
            server.addCacheEventFilterFactory("static-filter-factory", (CacheEventFilterFactory)new EventLogListener.StaticCacheEventFilterFactory(key1));
        }
        final EventLogListener.StaticFilteredEventLogListener eventListener = new EventLogListener.StaticFilteredEventLogListener();
        HotRodClientTestingUtil.withClientListener(eventListener, new RemoteCacheManagerCallable(this.client(0)){

            @Override
            public void call() {
                RemoteCache remote = ClientClusterEventsTest.this.client(0).getCache();
                eventListener.expectNoEvents();
                remote.put((Object)key0, (Object)"one");
                eventListener.expectNoEvents();
                remote.put((Object)key1, (Object)"two");
                eventListener.expectOnlyCreatedEvent(key1, ClientClusterEventsTest.this.cache(0));
                remote.remove((Object)key0);
                eventListener.expectNoEvents();
                remote.remove((Object)key1);
                eventListener.expectOnlyRemovedEvent(key1, ClientClusterEventsTest.this.cache(0));
            }
        });
    }

    public void testConversionInCluster() {
        final Integer key0 = HotRodClientTestingUtil.getIntKeyForServer(this.server(0));
        final Integer key1 = HotRodClientTestingUtil.getIntKeyForServer(this.server(1));
        final CustomEventLogListener.StaticCustomEventLogListener eventListener = new CustomEventLogListener.StaticCustomEventLogListener();
        HotRodClientTestingUtil.withClientListener(eventListener, new RemoteCacheManagerCallable(this.client(0)){

            @Override
            public void call() {
                RemoteCache c3 = ClientClusterEventsTest.this.client(0).getCache();
                eventListener.expectNoEvents();
                c3.put((Object)key0, (Object)"one");
                eventListener.expectCreatedEvent(new CustomEventLogListener.CustomEvent(key0, "one", 0));
                c3.put((Object)key1, (Object)"two");
                eventListener.expectCreatedEvent(new CustomEventLogListener.CustomEvent(key1, "two", 0));
                c3.remove((Object)key0);
                eventListener.expectRemovedEvent(new CustomEventLogListener.CustomEvent(key0, null, 0));
                c3.remove((Object)key1);
                eventListener.expectRemovedEvent(new CustomEventLogListener.CustomEvent(key1, null, 0));
            }
        });
    }

    public void testFilterCustomEventsInCluster() {
        final Integer key0 = HotRodClientTestingUtil.getIntKeyForServer(this.server(0));
        final Integer key1 = HotRodClientTestingUtil.getIntKeyForServer(this.server(1));
        final CustomEventLogListener.FilterCustomEventLogListener eventListener = new CustomEventLogListener.FilterCustomEventLogListener();
        HotRodClientTestingUtil.withClientListener(eventListener, new Object[]{key0}, null, new RemoteCacheManagerCallable(this.client(0)){

            @Override
            public void call() {
                RemoteCache remote = ClientClusterEventsTest.this.client(0).getCache();
                remote.put((Object)key0, (Object)"one");
                eventListener.expectCreatedEvent(new CustomEventLogListener.CustomEvent(key0, null, 1));
                remote.put((Object)key0, (Object)"newone");
                eventListener.expectModifiedEvent(new CustomEventLogListener.CustomEvent(key0, null, 2));
                remote.put((Object)key1, (Object)"two");
                eventListener.expectCreatedEvent(new CustomEventLogListener.CustomEvent(key1, "two", 1));
                remote.put((Object)key1, (Object)"dos");
                eventListener.expectModifiedEvent(new CustomEventLogListener.CustomEvent(key1, "dos", 2));
                remote.remove((Object)key0);
                eventListener.expectRemovedEvent(new CustomEventLogListener.CustomEvent(key0, null, 3));
                remote.remove((Object)key1);
                eventListener.expectRemovedEvent(new CustomEventLogListener.CustomEvent(key1, null, 3));
            }
        });
    }
}

