/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.event;

import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.event.ClientEvent;
import org.infinispan.client.hotrod.event.EventLogListener;
import org.infinispan.client.hotrod.event.FailoverEventLogListener;
import org.infinispan.client.hotrod.event.StickyServerLoadBalancingStrategy;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.event.ClientClusterFailoverEventsTest")
public class ClientClusterFailoverEventsTest
extends MultiHotRodServersTest {
    protected void createCacheManagers() throws Throwable {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEventReplayWithAndWithoutStateAfterFailover() {
        org.infinispan.configuration.cache.ConfigurationBuilder base = ClientClusterFailoverEventsTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false);
        org.infinispan.configuration.cache.ConfigurationBuilder builder = HotRodTestingUtil.hotRodCacheConfiguration((org.infinispan.configuration.cache.ConfigurationBuilder)base);
        this.createHotRodServers(2, builder);
        try {
            Integer key0 = HotRodClientTestingUtil.getIntKeyForServer(this.server(0));
            Integer key11 = HotRodClientTestingUtil.getIntKeyForServer(this.server(1));
            Integer key21 = HotRodClientTestingUtil.getIntKeyForServer(this.server(1));
            Integer key31 = HotRodClientTestingUtil.getIntKeyForServer(this.server(1));
            ConfigurationBuilder clientBuilder = new ConfigurationBuilder();
            HotRodServer server = this.server(0);
            clientBuilder.addServers(server.getHost() + ":" + server.getPort());
            clientBuilder.balancingStrategy(StickyServerLoadBalancingStrategy.class);
            RemoteCacheManager newClient = new RemoteCacheManager(clientBuilder.build());
            try {
                WithStateEventLogListener<Integer> statefulListener = new WithStateEventLogListener<Integer>();
                EventLogListener<Integer> statelessListener = new EventLogListener<Integer>();
                FailoverEventLogListener<Integer> failoverListener = new FailoverEventLogListener<Integer>();
                RemoteCache c = newClient.getCache();
                c.addClientListener(statelessListener);
                c.addClientListener(statefulListener);
                c.addClientListener(failoverListener);
                c.put((Object)key0, (Object)"zero");
                statefulListener.expectOnlyCreatedEvent(key0, this.cache(0));
                statelessListener.expectOnlyCreatedEvent(key0, this.cache(0));
                failoverListener.expectOnlyCreatedEvent(key0, this.cache(0));
                c.put((Object)key11, (Object)"one");
                statefulListener.expectOnlyCreatedEvent(key11, this.cache(0));
                statelessListener.expectOnlyCreatedEvent(key11, this.cache(0));
                failoverListener.expectOnlyCreatedEvent(key11, this.cache(0));
                HotRodClientTestingUtil.findServerAndKill(newClient, this.servers, this.cacheManagers);
                c.put((Object)key21, (Object)"two");
                statelessListener.expectNoEvents();
                statefulListener.expectFailoverEvent();
                failoverListener.expectFailoverEvent();
                statelessListener.expectNoEvents();
                failoverListener.expectNoEvents();
                statefulListener.expectUnorderedEvents(ClientEvent.Type.CLIENT_CACHE_ENTRY_CREATED, key0, key11, key21);
                c.put((Object)key31, (Object)"three");
                statefulListener.expectUnorderedEvents(ClientEvent.Type.CLIENT_CACHE_ENTRY_CREATED, key31);
                c.remove((Object)key11);
                c.remove((Object)key21);
                c.remove((Object)key31);
            }
            finally {
                HotRodClientTestingUtil.killRemoteCacheManager(newClient);
            }
        }
        finally {
            this.destroy();
        }
    }

    @ClientListener(includeCurrentState=true)
    public static class WithStateEventLogListener<K>
    extends FailoverEventLogListener<K> {
    }
}

