/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.event;

import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.event.CustomEventLogListener;
import org.infinispan.client.hotrod.event.EventLogListener;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.RemoteCacheManagerCallable;
import org.infinispan.client.hotrod.test.SingleHotRodServerTest;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilterFactory;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.event.ClientFilterEventsTest")
public class ClientFilterEventsTest
extends SingleHotRodServerTest {
    @Override
    protected HotRodServer createHotRodServer() {
        HotRodServerConfigurationBuilder builder = new HotRodServerConfigurationBuilder();
        HotRodServer server = HotRodClientTestingUtil.startHotRodServer(this.cacheManager, builder);
        server.addCacheEventFilterFactory("static-filter-factory", (CacheEventFilterFactory)new EventLogListener.StaticCacheEventFilterFactory(2));
        server.addCacheEventFilterFactory("dynamic-filter-factory", (CacheEventFilterFactory)new EventLogListener.DynamicCacheEventFilterFactory());
        server.addCacheEventFilterFactory("raw-static-filter-factory", (CacheEventFilterFactory)new EventLogListener.RawStaticCacheEventFilterFactory());
        return server;
    }

    public void testFilteredEvents() {
        final EventLogListener.StaticFilteredEventLogListener eventListener = new EventLogListener.StaticFilteredEventLogListener();
        HotRodClientTestingUtil.withClientListener(eventListener, new RemoteCacheManagerCallable(this.remoteCacheManager){

            @Override
            public void call() {
                RemoteCache cache = this.rcm.getCache();
                eventListener.expectNoEvents();
                cache.put((Object)1, (Object)"one");
                eventListener.expectNoEvents();
                cache.put((Object)2, (Object)"two");
                eventListener.expectOnlyCreatedEvent(2, ClientFilterEventsTest.this.cache());
                cache.remove((Object)1);
                eventListener.expectNoEvents();
                cache.remove((Object)2);
                eventListener.expectOnlyRemovedEvent(2, ClientFilterEventsTest.this.cache());
            }
        });
    }

    public void testParameterBasedFiltering() {
        final EventLogListener.DynamicFilteredEventLogListener eventListener = new EventLogListener.DynamicFilteredEventLogListener();
        HotRodClientTestingUtil.withClientListener(eventListener, new Object[]{3}, null, new RemoteCacheManagerCallable(this.remoteCacheManager){

            @Override
            public void call() {
                RemoteCache cache = this.rcm.getCache();
                eventListener.expectNoEvents();
                cache.put((Object)1, (Object)"one");
                eventListener.expectNoEvents();
                cache.put((Object)2, (Object)"two");
                eventListener.expectNoEvents();
                cache.put((Object)3, (Object)"three");
                eventListener.expectOnlyCreatedEvent(3, ClientFilterEventsTest.this.cache());
            }
        });
    }

    public void testFilteredEventsReplay() {
        final EventLogListener.StaticFilteredEventLogWithStateListener staticEventListener = new EventLogListener.StaticFilteredEventLogWithStateListener();
        RemoteCache cache = this.remoteCacheManager.getCache();
        cache.put((Object)1, (Object)"one");
        cache.put((Object)2, (Object)"two");
        HotRodClientTestingUtil.withClientListener(staticEventListener, new RemoteCacheManagerCallable(this.remoteCacheManager){

            @Override
            public void call() {
                staticEventListener.expectOnlyCreatedEvent(2, ClientFilterEventsTest.this.cache());
                RemoteCache cache = this.rcm.getCache();
                cache.remove((Object)1);
                cache.remove((Object)2);
                staticEventListener.expectOnlyRemovedEvent(2, ClientFilterEventsTest.this.cache());
            }
        });
        final EventLogListener.DynamicFilteredEventLogWithStateListener dynamicEventListener = new EventLogListener.DynamicFilteredEventLogWithStateListener();
        cache.put((Object)1, (Object)"one");
        cache.put((Object)2, (Object)"two");
        cache.put((Object)3, (Object)"three");
        HotRodClientTestingUtil.withClientListener(dynamicEventListener, new Object[]{3}, null, new RemoteCacheManagerCallable(this.remoteCacheManager){

            @Override
            public void call() {
                dynamicEventListener.expectOnlyCreatedEvent(3, ClientFilterEventsTest.this.cache());
                RemoteCache cache = this.rcm.getCache();
                cache.remove((Object)1);
                cache.remove((Object)2);
                cache.remove((Object)3);
                dynamicEventListener.expectOnlyRemovedEvent(3, ClientFilterEventsTest.this.cache());
            }
        });
    }

    public void testFilteredNoEventsReplay() {
        final EventLogListener.StaticFilteredEventLogListener staticEventListener = new EventLogListener.StaticFilteredEventLogListener();
        RemoteCache cache = this.remoteCacheManager.getCache();
        cache.put((Object)1, (Object)"one");
        cache.put((Object)2, (Object)"two");
        HotRodClientTestingUtil.withClientListener(staticEventListener, new RemoteCacheManagerCallable(this.remoteCacheManager){

            @Override
            public void call() {
                staticEventListener.expectNoEvents();
                RemoteCache cache = this.rcm.getCache();
                cache.remove((Object)1);
                cache.remove((Object)2);
                staticEventListener.expectOnlyRemovedEvent(2, ClientFilterEventsTest.this.cache());
            }
        });
        final EventLogListener.DynamicFilteredEventLogListener dynamicEventListener = new EventLogListener.DynamicFilteredEventLogListener();
        cache.put((Object)1, (Object)"one");
        cache.put((Object)2, (Object)"two");
        cache.put((Object)3, (Object)"three");
        HotRodClientTestingUtil.withClientListener(dynamicEventListener, new Object[]{3}, null, new RemoteCacheManagerCallable(this.remoteCacheManager){

            @Override
            public void call() {
                staticEventListener.expectNoEvents();
                RemoteCache cache = this.rcm.getCache();
                cache.remove((Object)1);
                cache.remove((Object)2);
                cache.remove((Object)3);
                dynamicEventListener.expectOnlyRemovedEvent(3, ClientFilterEventsTest.this.cache());
            }
        });
    }

    @Test(expectedExceptions={HotRodClientException.class})
    public void testNonExistingConverterFactoryCustomEvents() {
        NonExistingFilterFactoryListener eventListener = new NonExistingFilterFactoryListener();
        HotRodClientTestingUtil.withClientListener(eventListener, new RemoteCacheManagerCallable(this.remoteCacheManager));
    }

    public void testRawFilteredEvents() {
        final EventLogListener.RawStaticFilteredEventLogListener eventListener = new EventLogListener.RawStaticFilteredEventLogListener();
        HotRodClientTestingUtil.withClientListener(eventListener, new RemoteCacheManagerCallable(this.remoteCacheManager){

            @Override
            public void call() {
                RemoteCache cache = this.rcm.getCache();
                eventListener.expectNoEvents();
                cache.put((Object)1, (Object)"one");
                eventListener.expectNoEvents();
                cache.put((Object)2, (Object)"two");
                eventListener.expectOnlyCreatedEvent(2, ClientFilterEventsTest.this.cache());
                cache.remove((Object)1);
                eventListener.expectNoEvents();
                cache.remove((Object)2);
                eventListener.expectOnlyRemovedEvent(2, ClientFilterEventsTest.this.cache());
            }
        });
    }

    @ClientListener(filterFactoryName="non-existing-test-filter-factory")
    public static class NonExistingFilterFactoryListener
    extends CustomEventLogListener {
    }
}

