/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.event;

import java.net.SocketTimeoutException;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.SocketTimeoutErrorTest;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.event.EventLogListener;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.RemoteCacheManagerCallable;
import org.infinispan.client.hotrod.test.SingleHotRodServerTest;
import org.infinispan.interceptors.EntryWrappingInterceptor;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.event.EventSocketTimeoutTest")
public class EventSocketTimeoutTest
extends SingleHotRodServerTest {
    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = new org.infinispan.configuration.cache.ConfigurationBuilder();
        builder.customInterceptors().addInterceptor().interceptor((CommandInterceptor)new SocketTimeoutErrorTest.TimeoutInducingInterceptor()).after(EntryWrappingInterceptor.class);
        return TestCacheManagerFactory.createCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration((org.infinispan.configuration.cache.ConfigurationBuilder)builder));
    }

    @Override
    protected HotRodServer createHotRodServer() {
        HotRodServerConfigurationBuilder builder = new HotRodServerConfigurationBuilder();
        builder.workerThreads(6);
        return HotRodClientTestingUtil.startHotRodServer(this.cacheManager, builder);
    }

    @Override
    protected RemoteCacheManager getRemoteCacheManager() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.addServer().host("127.0.0.1").port(this.hotrodServer.getPort());
        builder.socketTimeout(2000);
        builder.maxRetries(0);
        return new RemoteCacheManager(builder.build());
    }

    public void testSocketTimeoutWithEvent() {
        final EventLogListener eventListener = new EventLogListener();
        HotRodClientTestingUtil.withClientListener(eventListener, new RemoteCacheManagerCallable(this.remoteCacheManager){

            @Override
            public void call() {
                RemoteCache cache = this.rcm.getCache();
                eventListener.expectNoEvents();
                cache.put((Object)"uno", (Object)1);
                eventListener.expectOnlyCreatedEvent("uno", EventSocketTimeoutTest.this.cache());
                try {
                    cache.put((Object)"FailFailFail", (Object)99);
                    Assert.fail((String)"SocketTimeoutException expected");
                }
                catch (HotRodClientException e) {
                    AssertJUnit.assertTrue((boolean)(e.getCause() instanceof SocketTimeoutException));
                }
                cache.put((Object)"dos", (Object)2);
                eventListener.expectOnlyCreatedEvent("dos", EventSocketTimeoutTest.this.cache());
            }
        });
    }
}

