/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.event;

import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.Search;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.event.ClientEvents;
import org.infinispan.client.hotrod.event.ContinuousQueryListener;
import org.infinispan.client.hotrod.marshall.ProtoStreamMarshaller;
import org.infinispan.client.hotrod.query.testdomain.protobuf.UserPB;
import org.infinispan.client.hotrod.query.testdomain.protobuf.marshallers.MarshallerRegistration;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Index;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilterConverterFactory;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.embedded.testdomain.User;
import org.infinispan.query.remote.filter.JPAContinuousQueryCacheEventFilterConverterFactory;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.junit.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.event.RemoteContinuousQueryTest")
public class RemoteContinuousQueryTest
extends MultiHotRodServersTest {
    private final int NUM_NODES = 5;
    private RemoteCache<Object, Object> remoteCache;

    protected void createCacheManagers() throws Throwable {
        org.infinispan.configuration.cache.ConfigurationBuilder cfgBuilder = this.getConfigurationBuilder();
        this.createHotRodServers(5, cfgBuilder);
        this.waitForClusterToForm();
        JPAContinuousQueryCacheEventFilterConverterFactory factory = new JPAContinuousQueryCacheEventFilterConverterFactory();
        this.server(0).addCacheEventFilterConverterFactory("continuous-query-filter-converter-factory", (CacheEventFilterConverterFactory)factory);
        this.remoteCache = this.client(0).getCache();
        RemoteCache metadataCache = this.client(0).getCache("___protobuf_metadata");
        metadataCache.put((Object)"sample_bank_account/bank.proto", (Object)Util.read((InputStream)Util.getResourceAsStream((String)"/sample_bank_account/bank.proto", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader())));
        Assert.assertFalse((boolean)metadataCache.containsKey((Object)".errors"));
        MarshallerRegistration.registerMarshallers(ProtoStreamMarshaller.getSerializationContext((RemoteCacheManager)this.client(0)));
    }

    protected org.infinispan.configuration.cache.ConfigurationBuilder getConfigurationBuilder() {
        org.infinispan.configuration.cache.ConfigurationBuilder cfgBuilder = HotRodTestingUtil.hotRodCacheConfiguration((org.infinispan.configuration.cache.ConfigurationBuilder)RemoteContinuousQueryTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false));
        cfgBuilder.indexing().index(Index.ALL).addProperty("default.directory_provider", "ram").addProperty("lucene_version", "LUCENE_CURRENT");
        return cfgBuilder;
    }

    @Override
    protected ConfigurationBuilder createHotRodClientConfigurationBuilder(int serverPort) {
        return super.createHotRodClientConfigurationBuilder(serverPort).marshaller((Marshaller)new ProtoStreamMarshaller());
    }

    public void testContinuousQuery() throws Exception {
        UserPB user1 = new UserPB();
        user1.setId(1);
        user1.setName("John");
        user1.setSurname("Doe");
        user1.setGender(User.Gender.MALE);
        user1.setAge(22);
        user1.setAccountIds(new HashSet<Integer>(Arrays.asList(1, 2)));
        user1.setNotes("Lorem ipsum dolor sit amet");
        UserPB user2 = new UserPB();
        user2.setId(2);
        user2.setName("Spider");
        user2.setSurname("Man");
        user2.setGender(User.Gender.MALE);
        user2.setAge(32);
        user2.setAccountIds(Collections.singleton(3));
        UserPB user3 = new UserPB();
        user3.setId(3);
        user3.setName("Spider");
        user3.setSurname("Woman");
        user3.setGender(User.Gender.FEMALE);
        user3.setAge(40);
        user3.setAccountIds(Collections.emptySet());
        this.remoteCache.put((Object)("user" + user1.getId()), (Object)user1);
        this.remoteCache.put((Object)("user" + user2.getId()), (Object)user2);
        this.remoteCache.put((Object)("user" + user3.getId()), (Object)user3);
        Assert.assertEquals((long)3L, (long)this.remoteCache.size());
        QueryFactory qf = Search.getQueryFactory(this.remoteCache);
        Query query = qf.from(UserPB.class).having("age").lte((Object)32).toBuilder().select(new String[]{"age"}).build();
        final ArrayBlockingQueue<Object> joined = new ArrayBlockingQueue<Object>(50);
        final ArrayBlockingQueue<Object> left = new ArrayBlockingQueue<Object>(50);
        ContinuousQueryListener listener = new ContinuousQueryListener(){

            public void resultJoining(Object key, Object value) {
                joined.add(key);
            }

            public void resultLeaving(Object key) {
                left.add(key);
            }
        };
        Object clientListener = ClientEvents.addContinuousQueryListener(this.remoteCache, (ContinuousQueryListener)listener, (Query)query);
        Assert.assertNotNull((Object)clientListener);
        this.expectElementsInQueue(joined, 2);
        this.expectElementsInQueue(left, 0);
        user3.setAge(30);
        this.remoteCache.put((Object)("user" + user3.getId()), (Object)user3);
        this.expectElementsInQueue(joined, 1);
        this.expectElementsInQueue(left, 0);
        user1.setAge(40);
        user2.setAge(40);
        user3.setAge(40);
        this.remoteCache.put((Object)("user" + user1.getId()), (Object)user1);
        this.remoteCache.put((Object)("user" + user2.getId()), (Object)user2);
        this.remoteCache.put((Object)("user" + user3.getId()), (Object)user3);
        this.expectElementsInQueue(joined, 0);
        this.expectElementsInQueue(left, 3);
        this.remoteCache.removeClientListener(clientListener);
        user2.setAge(22);
        this.remoteCache.put((Object)("user" + user2.getId()), (Object)user2);
        this.expectElementsInQueue(joined, 0);
        this.expectElementsInQueue(left, 0);
    }

    private void expectElementsInQueue(BlockingQueue<Object> queue, int numElements) {
        for (int i = 0; i < numElements; ++i) {
            try {
                Object e = queue.poll(5L, TimeUnit.SECONDS);
                Assert.assertNotNull((Object)e);
                continue;
            }
            catch (InterruptedException e) {
                throw new AssertionError("Interrupted while waiting for condition", e);
            }
        }
        try {
            Object e = queue.poll(5L, TimeUnit.SECONDS);
            Assert.assertNull((Object)e);
        }
        catch (InterruptedException e) {
            throw new AssertionError("Interrupted while waiting for condition", e);
        }
    }
}

