/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.iteration;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.impl.iteration.AbstractRemoteIteratorTest;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.filter.AbstractKeyValueFilterConverter;
import org.infinispan.filter.KeyValueFilterConverter;
import org.infinispan.filter.KeyValueFilterConverterFactory;
import org.infinispan.metadata.Metadata;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public abstract class BaseMultiServerRemoteIteratorTest
extends MultiHotRodServersTest
implements AbstractRemoteIteratorTest {
    public static final int CACHE_SIZE = 20;

    @BeforeMethod
    public void clear() {
        this.clients.forEach(c -> c.getCache().clear());
    }

    @Test
    public void testBatchSizes() {
        int maximumBatchSize = 120;
        RemoteCache cache = ((RemoteCacheManager)this.clients.get(0)).getCache();
        this.populateCache(20, this::newAccount, cache);
        Set expectedKeys = this.rangeAsSet(0, 20);
        for (int batch = 1; batch < maximumBatchSize; batch += 10) {
            HashSet results = new HashSet(20);
            CloseableIterator iterator = cache.retrieveEntries(null, null, batch);
            iterator.forEachRemaining(results::add);
            iterator.close();
            AssertJUnit.assertEquals((int)20, (int)results.size());
            AssertJUnit.assertEquals((Object)expectedKeys, (Object)this.extractKeys(results));
        }
    }

    @Test
    public void testEmptyCache() {
        try (CloseableIterator iterator = this.client(0).getCache().retrieveEntries(null, null, 100);){
            AssertJUnit.assertFalse((boolean)iterator.hasNext());
            AssertJUnit.assertFalse((boolean)iterator.hasNext());
        }
    }

    @Test
    public void testFilterBySegmentAndCustomFilter() {
        String toHexConverterName = "toHexConverter";
        this.servers.forEach(s -> s.addKeyValueFilterConverterFactory(toHexConverterName, (KeyValueFilterConverterFactory)new ToHexConverterFactory()));
        RemoteCache numbersCache = ((RemoteCacheManager)this.clients.get(0)).getCache();
        this.populateCache(20, i -> i, numbersCache);
        Set segments = this.setOf(new Integer[]{15, 20, 25});
        HashSet<Object> entries = new HashSet<Object>();
        try (CloseableIterator iterator = numbersCache.retrieveEntries(toHexConverterName, segments, 10);){
            while (iterator.hasNext()) {
                entries.add(iterator.next());
            }
        }
        Set values = this.extractValues(entries);
        this.getKeysFromSegments(segments).forEach(i -> Assert.assertTrue((boolean)values.contains(Integer.toHexString(i))));
    }

    @Test
    public void testFilterBySegment() {
        RemoteCache cache = ((RemoteCacheManager)this.clients.get(0)).getCache();
        this.populateCache(20, this::newAccount, cache);
        Set filterBySegments = this.rangeAsSet(30, 40);
        HashSet<Object> entries = new HashSet<Object>();
        try (CloseableIterator iterator = cache.retrieveEntries(null, filterBySegments, 10);){
            while (iterator.hasNext()) {
                entries.add(iterator.next());
            }
        }
        Marshaller marshaller = ((RemoteCacheManager)this.clients.iterator().next()).getMarshaller();
        ConsistentHash consistentHash = this.advancedCache(0).getDistributionManager().getConsistentHash();
        this.assertKeysInSegment(entries, filterBySegments, marshaller, arg_0 -> ((ConsistentHash)consistentHash).getSegment(arg_0));
    }

    private Set<Integer> getKeysFromSegments(Set<Integer> segments) {
        RemoteCacheManager remoteCacheManager = (RemoteCacheManager)this.clients.get(0);
        RemoteCache cache = remoteCacheManager.getCache();
        Marshaller marshaller = ((RemoteCacheManager)this.clients.get(0)).getMarshaller();
        ConsistentHash hash = this.advancedCache(0).getDistributionManager().getConsistentHash();
        Set keys = cache.keySet();
        return keys.stream().filter(b -> segments.contains(hash.getSegment((Object)this.toByteBuffer(b, marshaller)))).collect(Collectors.toSet());
    }

    static final class ToHexConverterFactory
    implements KeyValueFilterConverterFactory<Integer, Integer, String> {
        ToHexConverterFactory() {
        }

        public KeyValueFilterConverter<Integer, Integer, String> getFilterConverter() {
            return new HexFilterConverter();
        }

        static class HexFilterConverter
        extends AbstractKeyValueFilterConverter<Integer, Integer, String>
        implements Serializable {
            HexFilterConverter() {
            }

            public String filterAndConvert(Integer key, Integer value, Metadata metadata) {
                return Integer.toHexString(value);
            }
        }
    }
}

