/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.iteration;

import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.impl.iteration.AbstractRemoteIteratorTest;
import org.infinispan.client.hotrod.test.SingleHotRodServerTest;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.InfinispanCollections;
import org.infinispan.filter.AbstractKeyValueFilterConverter;
import org.infinispan.metadata.Metadata;
import org.infinispan.query.dsl.embedded.testdomain.hsearch.AccountHS;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.iteration.RemoteIteratorTest")
public class SingleServerRemoteIteratorTest
extends SingleHotRodServerTest
implements AbstractRemoteIteratorTest {
    public static final String FILTER_CONVERTER_FACTORY_NAME = "even-accounts-descriptions";

    @Test
    public void testEmptyCache() {
        try (CloseableIterator iterator = this.remoteCacheManager.getCache().retrieveEntries(null, null, 100);){
            Assert.assertFalse((boolean)iterator.hasNext());
            Assert.assertFalse((boolean)iterator.hasNext());
        }
    }

    @Test
    public void testEmptySegments() {
        this.populateCache(1, i -> "value " + i, this.remoteCacheManager.getCache());
        try (CloseableIterator iterator = this.remoteCacheManager.getCache().retrieveEntries(null, InfinispanCollections.emptySet(), 100);){
            Assert.assertFalse((boolean)iterator.hasNext());
        }
    }

    @Test(expectedExceptions={HotRodClientException.class}, expectedExceptionsMessageRegExp=".*ISPN006016.*")
    public void testEmptyFilter() {
        try (CloseableIterator iterator = this.remoteCacheManager.getCache().retrieveEntries("", null, 100);){
            Assert.assertFalse((boolean)iterator.hasNext());
        }
    }

    @Test(expectedExceptions={NoSuchElementException.class})
    public void testException1() {
        try (CloseableIterator iterator = null;){
            iterator = this.remoteCacheManager.getCache().retrieveEntries(null, null, 100);
            iterator.next();
        }
    }

    @Test(expectedExceptions={NoSuchElementException.class})
    public void testException2() {
        this.populateCache(3, i -> "value " + i, this.remoteCacheManager.getCache());
        CloseableIterator iterator = this.remoteCacheManager.getCache().retrieveEntries(null, null, 100);
        iterator.close();
        iterator.next();
    }

    public void testResultsSingleFetch() {
        RemoteCache cache = this.remoteCacheManager.getCache();
        this.populateCache(3, i -> "value " + i, cache);
        HashSet<Object> entries = new HashSet<Object>();
        try (CloseableIterator iterator = cache.retrieveEntries(null, null, 5);){
            entries.add(iterator.next());
            entries.add(iterator.next());
            entries.add(iterator.next());
        }
        Set keys = this.extractKeys(entries);
        Set values = this.extractValues(entries);
        AssertJUnit.assertEquals((Object)keys, (Object)this.setOf(new Integer[]{0, 1, 2}));
        AssertJUnit.assertEquals((Object)values, (Object)this.setOf(new String[]{"value 0", "value 1", "value 2"}));
    }

    public void testResultsMultipleFetches() {
        RemoteCache cache = this.remoteCacheManager.getCache();
        int cacheSize = 100;
        this.populateCache(cacheSize, i -> "value " + i, cache);
        HashSet<Object> entries = new HashSet<Object>();
        try (CloseableIterator iterator = cache.retrieveEntries(null, null, 5);){
            while (iterator.hasNext()) {
                entries.add(iterator.next());
            }
        }
        Set keys = this.extractKeys(entries);
        AssertJUnit.assertEquals((Object)this.rangeAsSet(0, cacheSize), (Object)keys);
    }

    public void testEntities() {
        RemoteCache cache = this.remoteCacheManager.getCache();
        int cacheSize = 50;
        this.populateCache(cacheSize, this::newAccount, cache);
        HashSet<Object> entries = new HashSet<Object>();
        try (CloseableIterator iterator = cache.retrieveEntries(null, null, 5);){
            while (iterator.hasNext()) {
                entries.add(iterator.next());
            }
        }
        AssertJUnit.assertEquals((int)cacheSize, (int)entries.size());
        Set values = this.extractValues(entries);
        this.assertForAll(values, v -> v != null);
        this.assertForAll(values, v -> v.getId() < cacheSize);
    }

    public void testFilterConverter() {
        this.hotrodServer.addKeyValueFilterConverterFactory(FILTER_CONVERTER_FACTORY_NAME, () -> new AbstractKeyValueFilterConverter<Integer, AccountHS, String>(){

            public String filterAndConvert(Integer key, AccountHS value, Metadata metadata) {
                if (key % 2 != 0) {
                    return null;
                }
                return value.getDescription();
            }
        });
        RemoteCache cache = this.remoteCacheManager.getCache();
        int cacheSize = 50;
        this.populateCache(cacheSize, this::newAccount, cache);
        HashSet<Object> entries = new HashSet<Object>();
        try (CloseableIterator iterator = cache.retrieveEntries(FILTER_CONVERTER_FACTORY_NAME, null, 5);){
            while (iterator.hasNext()) {
                entries.add(iterator.next());
            }
        }
        AssertJUnit.assertEquals((int)(cacheSize / 2), (int)entries.size());
        Set keys = this.extractKeys(entries);
        this.assertForAll(keys, v -> v % 2 == 0);
    }
}

