/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.marshall;

import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.marshall.ProtoStreamMarshaller;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoMessage;
import org.infinispan.protostream.annotations.ProtoSchemaBuilder;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.junit.Assert;
import org.testng.annotations.AfterTest;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.marshall.ProtoStreamMarshallerWithAnnotationsTest", groups={"functional"})
@CleanupAfterMethod
public class ProtoStreamMarshallerWithAnnotationsTest
extends SingleCacheManagerTest {
    private HotRodServer hotRodServer;
    private RemoteCacheManager remoteCacheManager;
    private RemoteCache<Integer, AnnotatedUser> remoteCache;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        this.cacheManager = TestCacheManagerFactory.createCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration());
        this.cache = this.cacheManager.getCache();
        this.hotRodServer = HotRodClientTestingUtil.startHotRodServer(this.cacheManager);
        ConfigurationBuilder clientBuilder = new ConfigurationBuilder();
        clientBuilder.addServer().host("127.0.0.1").port(this.hotRodServer.getPort());
        clientBuilder.marshaller((Marshaller)new ProtoStreamMarshaller());
        this.remoteCacheManager = new RemoteCacheManager(clientBuilder.build());
        this.remoteCache = this.remoteCacheManager.getCache();
        SerializationContext serializationContext = ProtoStreamMarshaller.getSerializationContext((RemoteCacheManager)this.remoteCacheManager);
        ProtoSchemaBuilder protoSchemaBuilder = new ProtoSchemaBuilder();
        protoSchemaBuilder.fileName("test.proto").addClass(AnnotatedUser.class).build(serializationContext);
        return this.cacheManager;
    }

    @AfterTest
    public void release() {
        HotRodClientTestingUtil.killRemoteCacheManager(this.remoteCacheManager);
        HotRodClientTestingUtil.killServers(this.hotRodServer);
    }

    public void testPutAndGet() throws Exception {
        AnnotatedUser user = this.createUser();
        this.remoteCache.put((Object)1, (Object)user);
        Assert.assertEquals((long)1L, (long)this.cache.keySet().size());
        byte[] key = (byte[])this.cache.keySet().iterator().next();
        Object localObject = this.cache.get((Object)key);
        Assert.assertNotNull((Object)localObject);
        Assert.assertTrue((boolean)(localObject instanceof byte[]));
        Object unmarshalledObject = ProtobufUtil.fromWrappedByteArray((SerializationContext)ProtoStreamMarshaller.getSerializationContext((RemoteCacheManager)this.remoteCacheManager), (byte[])((byte[])localObject));
        Assert.assertTrue((boolean)(unmarshalledObject instanceof AnnotatedUser));
        this.assertUser((AnnotatedUser)unmarshalledObject);
        AnnotatedUser fromRemoteCache = (AnnotatedUser)this.remoteCache.get((Object)1);
        this.assertUser(fromRemoteCache);
    }

    private AnnotatedUser createUser() {
        AnnotatedUser user = new AnnotatedUser();
        user.setId(33);
        user.setName("Tom");
        return user;
    }

    private void assertUser(AnnotatedUser user) {
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((long)33L, (long)user.getId());
        Assert.assertEquals((Object)"Tom", (Object)user.getName());
    }

    @ProtoMessage(name="User")
    public static class AnnotatedUser {
        private int id;
        private String name;

        @ProtoField(number=1, required=true)
        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        @ProtoField(number=2)
        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String toString() {
            return "AnnotatedUser{id=" + this.id + ", name='" + this.name + "'}";
        }
    }
}

