/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.query;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.hibernate.search.spi.SearchIntegrator;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.Search;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.impl.query.RemoteQueryFactory;
import org.infinispan.client.hotrod.marshall.ProtoStreamMarshaller;
import org.infinispan.client.hotrod.query.testdomain.protobuf.ModelFactoryPB;
import org.infinispan.client.hotrod.query.testdomain.protobuf.marshallers.MarshallerRegistration;
import org.infinispan.client.hotrod.query.testdomain.protobuf.marshallers.NotIndexedMarshaller;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.Index;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryBuilder;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.SortOrder;
import org.infinispan.query.dsl.embedded.QueryDslConditionsTest;
import org.infinispan.query.dsl.embedded.testdomain.Account;
import org.infinispan.query.dsl.embedded.testdomain.ModelFactory;
import org.infinispan.query.remote.indexing.ProtobufValueWrapper;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.junit.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.query.RemoteQueryDslConditionsTest")
public class RemoteQueryDslConditionsTest
extends QueryDslConditionsTest {
    private static final String NOT_INDEXED_PROTO_SCHEMA = "package sample_bank_account;\n/* @Indexed(false) */\nmessage NotIndexed {\n\toptional string notIndexedField = 1;\n}\n";
    protected HotRodServer hotRodServer;
    protected RemoteCacheManager remoteCacheManager;
    protected RemoteCache<Object, Object> remoteCache;
    protected Cache<Object, Object> cache;

    protected QueryFactory getQueryFactory() {
        return Search.getQueryFactory(this.remoteCache);
    }

    protected ModelFactory getModelFactory() {
        return ModelFactoryPB.INSTANCE;
    }

    protected RemoteCache<Object, Object> getCacheForQuery() {
        return this.remoteCache;
    }

    protected Cache<Object, Object> getEmbeddedCache() {
        return this.cache;
    }

    protected void createCacheManagers() throws Throwable {
        org.infinispan.configuration.cache.ConfigurationBuilder cfg = this.getConfigurationBuilder();
        this.createClusteredCaches(1, cfg);
        this.cache = this.manager(0).getCache();
        this.hotRodServer = HotRodClientTestingUtil.startHotRodServer(this.manager(0));
        ConfigurationBuilder clientBuilder = new ConfigurationBuilder();
        clientBuilder.addServer().host("127.0.0.1").port(this.hotRodServer.getPort());
        clientBuilder.marshaller((Marshaller)new ProtoStreamMarshaller());
        this.remoteCacheManager = new RemoteCacheManager(clientBuilder.build());
        this.remoteCache = this.remoteCacheManager.getCache();
        this.initProtoSchema(this.remoteCacheManager);
    }

    protected void initProtoSchema(RemoteCacheManager remoteCacheManager) throws IOException {
        RemoteCache metadataCache = remoteCacheManager.getCache("___protobuf_metadata");
        metadataCache.put((Object)"sample_bank_account/bank.proto", (Object)Util.read((InputStream)Util.getResourceAsStream((String)"/sample_bank_account/bank.proto", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader())));
        Assert.assertFalse((boolean)metadataCache.containsKey((Object)".errors"));
        metadataCache.put((Object)"not_indexed.proto", (Object)NOT_INDEXED_PROTO_SCHEMA);
        SerializationContext serCtx = ProtoStreamMarshaller.getSerializationContext((RemoteCacheManager)remoteCacheManager);
        MarshallerRegistration.registerMarshallers(serCtx);
        serCtx.registerProtoFiles(FileDescriptorSource.fromString((String)"not_indexed.proto", (String)NOT_INDEXED_PROTO_SCHEMA));
        serCtx.registerMarshaller((BaseMarshaller)new NotIndexedMarshaller());
    }

    protected org.infinispan.configuration.cache.ConfigurationBuilder getConfigurationBuilder() {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = HotRodTestingUtil.hotRodCacheConfiguration();
        builder.indexing().index(Index.ALL).addProperty("default.directory_provider", "ram").addProperty("lucene_version", "LUCENE_CURRENT");
        return builder;
    }

    @AfterClass(alwaysRun=true)
    public void release() {
        HotRodClientTestingUtil.killRemoteCacheManager(this.remoteCacheManager);
        HotRodClientTestingUtil.killServers(this.hotRodServer);
    }

    public void testIndexPresence() {
        SearchIntegrator searchIntegrator = (SearchIntegrator)org.infinispan.query.Search.getSearchManager(this.cache).unwrap(SearchIntegrator.class);
        Assert.assertTrue((boolean)searchIntegrator.getIndexedTypes().contains(ProtobufValueWrapper.class));
        Assert.assertNotNull((Object)searchIntegrator.getIndexManager(ProtobufValueWrapper.class.getName()));
    }

    public void testQueryFactoryType() {
        Assert.assertEquals(RemoteQueryFactory.class, this.getQueryFactory().getClass());
    }

    @Test(enabled=false, expectedExceptions={HotRodClientException.class}, expectedExceptionsMessageRegExp=".*HQL100005:.*", description="see https://issues.jboss.org/browse/ISPN-4423")
    public void testInvalidEmbeddedAttributeQuery() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        QueryBuilder queryBuilder = qf.from(this.getModelFactory().getUserImplClass()).select(new String[]{"addresses"});
        Query q = queryBuilder.build();
        q.list();
    }

    public void testSampleDomainQuery9() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getTransactionImplClass()).select(new String[]{"date"}).having("date").between((Object)this.makeDate("2013-01-01"), (Object)this.makeDate("2013-01-31")).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)4L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((long)1L, (long)((Object[])list.get(1)).length);
        Assert.assertEquals((long)1L, (long)((Object[])list.get(2)).length);
        Assert.assertEquals((long)1L, (long)((Object[])list.get(3)).length);
        for (int i = 0; i < 4; ++i) {
            Long d = (Long)((Object[])list.get(i))[0];
            Assert.assertTrue((d <= this.makeDate("2013-01-31").getTime() ? 1 : 0) != 0);
            Assert.assertTrue((d >= this.makeDate("2013-01-01").getTime() ? 1 : 0) != 0);
        }
    }

    public void testDefaultValue() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getAccountImplClass()).orderBy("description", SortOrder.ASC).build();
        List list = q.list();
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((Object)"Checking account", (Object)((Account)list.get(0)).getDescription());
    }

    @Test(expectedExceptions={HotRodClientException.class}, expectedExceptionsMessageRegExp="org.hibernate.hql.ParsingException: The expression 'surname' must be part of an aggregate function or it should be included in the GROUP BY clause")
    public void testGroupBy3() throws Exception {
        super.testGroupBy3();
    }

    @Test(enabled=false)
    public void testIsNullNumericWithProjection1() throws Exception {
        super.testIsNullNumericWithProjection1();
    }

    @Test(enabled=false)
    public void testIsNullNumericWithProjection2() throws Exception {
        super.testIsNullNumericWithProjection2();
    }

    @Test(expectedExceptions={HotRodClientException.class}, expectedExceptionsMessageRegExp="org.hibernate.hql.ParsingException: Queries containing grouping and aggregation functions must use projections.")
    public void testGroupBy5() {
        super.testGroupBy5();
    }
}

