/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.util.Collections;
import javax.security.auth.callback.CallbackHandler;
import org.infinispan.client.hotrod.AbstractAuthenticationTest;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.exceptions.TransportException;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.security.simple.SimpleServerAuthenticationProvider;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.server.hotrod.test.TestCallbackHandler;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.AuthenticationTest", groups={"functional"})
@CleanupAfterMethod
public class AuthenticationTest
extends AbstractAuthenticationTest {
    protected HotRodServer hotrodServer;

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        this.cacheManager = TestCacheManagerFactory.createCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration());
        this.cacheManager.getCache();
        return this.cacheManager;
    }

    @Override
    protected SimpleServerAuthenticationProvider createAuthenticationProvider() {
        SimpleServerAuthenticationProvider sap = new SimpleServerAuthenticationProvider();
        sap.addUser("user", "realm", "password".toCharArray(), null);
        return sap;
    }

    @Test
    public void testAuthentication() {
        ConfigurationBuilder clientBuilder = this.initServerAndClient();
        clientBuilder.security().authentication().callbackHandler((CallbackHandler)new TestCallbackHandler("user", "realm", "password".toCharArray()));
        this.remoteCacheManager = new RemoteCacheManager(clientBuilder.build());
        RemoteCache defaultRemote = this.remoteCacheManager.getCache();
        defaultRemote.put((Object)"a", (Object)"a");
        AssertJUnit.assertEquals((String)"a", (String)((String)defaultRemote.get((Object)"a")));
    }

    @Test(expectedExceptions={TransportException.class})
    public void testAuthenticationFailWrongAuth() {
        ConfigurationBuilder clientBuilder = this.initServerAndClient();
        clientBuilder.security().authentication().callbackHandler((CallbackHandler)new TestCallbackHandler("user", "realm", "foobar".toCharArray()));
        this.remoteCacheManager = new RemoteCacheManager(clientBuilder.build());
        this.remoteCacheManager.getCache();
    }

    @Test(expectedExceptions={HotRodClientException.class}, expectedExceptionsMessageRegExp=".*ISPN006017:.*")
    public void testAuthenticationFailNoAuth() {
        ConfigurationBuilder clientBuilder = this.initServerAndClient(Collections.singletonMap("javax.security.sasl.policy.noanonymous", "true"));
        clientBuilder.security().authentication().disable();
        this.remoteCacheManager = new RemoteCacheManager(clientBuilder.build());
        RemoteCache cache = this.remoteCacheManager.getCache();
        cache.put((Object)"a", (Object)"a");
    }

    @Test
    public void testAuthenticationUsername() {
        ConfigurationBuilder clientBuilder = this.initServerAndClient();
        clientBuilder.security().authentication().username("user").realm("realm").password("password");
        this.remoteCacheManager = new RemoteCacheManager(clientBuilder.build());
        RemoteCache defaultRemote = this.remoteCacheManager.getCache();
        defaultRemote.put((Object)"a", (Object)"a");
        AssertJUnit.assertEquals((String)"a", (String)((String)defaultRemote.get((Object)"a")));
    }

    @Test(expectedExceptions={CacheConfigurationException.class}, expectedExceptionsMessageRegExp=".*ISPN004067.*")
    public void testAuthenticationUsernameWithCallbackFail() {
        ConfigurationBuilder clientBuilder = this.initServerAndClient();
        clientBuilder.security().authentication().username("user").realm("realm").password("password").callbackHandler((CallbackHandler)new TestCallbackHandler("user", "realm", "foobar".toCharArray()));
        this.remoteCacheManager = new RemoteCacheManager(clientBuilder.build());
    }
}

