/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.infinispan.Cache;
import org.infinispan.affinity.KeyAffinityService;
import org.infinispan.affinity.KeyAffinityServiceFactory;
import org.infinispan.affinity.KeyGenerator;
import org.infinispan.client.hotrod.HitsAwareCacheManagersTest;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.impl.RemoteCacheImpl;
import org.infinispan.client.hotrod.impl.transport.tcp.TcpTransportFactory;
import org.infinispan.client.hotrod.retry.DistributionRetryTest;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterTest;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.ConsistentHashV2IntegrationTest")
public class ConsistentHashV2IntegrationTest
extends MultipleCacheManagersTest {
    public static final int NUM_KEYS = 200;
    private HotRodServer hotRodServer1;
    private HotRodServer hotRodServer2;
    private HotRodServer hotRodServer3;
    private HotRodServer hotRodServer4;
    private RemoteCacheManager remoteCacheManager;
    private RemoteCacheImpl remoteCache;
    private KeyAffinityService kas;
    private ExecutorService ex;

    protected void createCacheManagers() throws Throwable {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = this.buildConfiguration();
        this.addClusterEnabledCacheManager(builder);
        this.addClusterEnabledCacheManager(builder);
        this.addClusterEnabledCacheManager(builder);
        this.addClusterEnabledCacheManager(builder);
        this.hotRodServer1 = HotRodClientTestingUtil.startHotRodServer(this.manager(0));
        this.hotRodServer2 = HotRodClientTestingUtil.startHotRodServer(this.manager(1));
        this.hotRodServer3 = HotRodClientTestingUtil.startHotRodServer(this.manager(2));
        this.hotRodServer4 = HotRodClientTestingUtil.startHotRodServer(this.manager(3));
        this.waitForClusterToForm();
        ConfigurationBuilder clientBuilder = new ConfigurationBuilder();
        clientBuilder.addServer().host("localhost").port(this.hotRodServer2.getPort());
        this.remoteCacheManager = new RemoteCacheManager(clientBuilder.build());
        this.remoteCache = (RemoteCacheImpl)this.remoteCacheManager.getCache();
        assert (this.cacheManagers.size() == 4);
        this.ex = Executors.newSingleThreadExecutor(this.getTestThreadFactory("KeyGenerator"));
        this.kas = KeyAffinityServiceFactory.newKeyAffinityService((Cache)this.cache(0), (Executor)this.ex, (KeyGenerator)new DistributionRetryTest.ByteKeyGenerator(), (int)2, (boolean)true);
        for (int i = 0; i < 4; ++i) {
            this.advancedCache(i).addInterceptor((CommandInterceptor)new HitsAwareCacheManagersTest.HitCountInterceptor(), 1);
        }
    }

    private org.infinispan.configuration.cache.ConfigurationBuilder buildConfiguration() {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = ConsistentHashV2IntegrationTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false);
        builder.jmxStatistics().enable();
        builder.clustering().hash().numOwners(2).stateTransfer().fetchInMemoryState(false);
        return HotRodTestingUtil.hotRodCacheConfiguration((org.infinispan.configuration.cache.ConfigurationBuilder)builder);
    }

    @AfterMethod
    protected void clearContent() throws Throwable {
    }

    @AfterTest
    public void cleanUp() {
        this.ex.shutdownNow();
        this.kas.stop();
        this.stopServer(this.hotRodServer1);
        this.stopServer(this.hotRodServer2);
        this.stopServer(this.hotRodServer3);
        this.stopServer(this.hotRodServer4);
        this.remoteCache.stop();
        this.remoteCacheManager.stop();
    }

    private void stopServer(HotRodServer hrs) {
        HotRodClientTestingUtil.killServers(hrs);
    }

    public void testCorrectBalancingOfKeys() {
        this.runTest(0);
        this.runTest(1);
        this.runTest(2);
        this.runTest(3);
    }

    private void runTest(int cacheIndex) {
        ConsistentHash serverCH = this.advancedCache(cacheIndex).getDistributionManager().getConsistentHash();
        for (int i = 0; i < 200; ++i) {
            byte[] keyBytes = (byte[])this.kas.getKeyForAddress(this.address(cacheIndex));
            String key = DistributionRetryTest.ByteKeyGenerator.getStringObject(keyBytes);
            Address serverPrimary = serverCH.locatePrimaryOwner((Object)keyBytes);
            AssertJUnit.assertEquals((Object)this.address(cacheIndex), (Object)serverPrimary);
            this.remoteCache.put((Object)key, (Object)"v");
        }
        AssertJUnit.assertTrue(((double)this.hitCountInterceptor(cacheIndex).getHits() > 198.0 ? 1 : 0) != 0);
        this.hitCountInterceptor(cacheIndex).reset();
    }

    public void testCorrectBalancingOfKeysAfterNodeKill() {
        final TcpTransportFactory transportFactory = (TcpTransportFactory)TestingUtil.extractField((Object)this.remoteCacheManager, (String)"transportFactory");
        final int topologyIdBeforeJoin = transportFactory.getTopologyId(new byte[0]);
        this.log.tracef("Starting test with client topology id %d", topologyIdBeforeJoin);
        EmbeddedCacheManager cm5 = this.addClusterEnabledCacheManager(this.buildConfiguration());
        HotRodServer hotRodServer5 = HotRodClientTestingUtil.startHotRodServer(cm5);
        this.eventually(new AbstractInfinispanTest.Condition(){

            public boolean isSatisfied() throws Exception {
                int topologyId = transportFactory.getTopologyId(new byte[0]);
                ConsistentHashV2IntegrationTest.this.log.tracef("Client topology id is %d, waiting for it to become %d", topologyId, topologyIdBeforeJoin + 2);
                ConsistentHashV2IntegrationTest.this.remoteCache.put((Object)"k", (Object)"v");
                return topologyId >= topologyIdBeforeJoin + 2;
            }
        });
        this.resetHitInterceptors();
        this.runTest(0);
        this.runTest(1);
        this.runTest(2);
        this.runTest(3);
        this.stopServer(hotRodServer5);
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{cm5});
        this.eventually(new AbstractInfinispanTest.Condition(){

            public boolean isSatisfied() throws Exception {
                int topologyId = transportFactory.getTopologyId(new byte[0]);
                ConsistentHashV2IntegrationTest.this.log.tracef("Client topology id is %d, waiting for it to become %d", topologyId, topologyIdBeforeJoin + 4);
                ConsistentHashV2IntegrationTest.this.remoteCache.put((Object)"k", (Object)"v");
                return topologyId >= topologyIdBeforeJoin + 4;
            }
        });
        this.resetHitInterceptors();
        this.runTest(0);
        this.runTest(1);
        this.runTest(2);
        this.runTest(3);
    }

    private void resetHitInterceptors() {
        for (int i = 0; i < 4; ++i) {
            HitsAwareCacheManagersTest.HitCountInterceptor interceptor = this.hitCountInterceptor(i);
            interceptor.reset();
        }
    }

    private HitsAwareCacheManagersTest.HitCountInterceptor hitCountInterceptor(int i) {
        AsyncInterceptorChain ic = this.advancedCache(i).getAsyncInterceptorChain();
        return (HitsAwareCacheManagersTest.HitCountInterceptor)ic.findInterceptorWithClass(HitsAwareCacheManagersTest.HitCountInterceptor.class);
    }
}

