/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.VersionedValue;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;
import org.testng.internal.junit.ArrayAsserts;

@Test(testName="client.hotrod.HotRodIntegrationTest", groups={"functional"})
public class HotRodIntegrationTest
extends SingleCacheManagerTest {
    private static final Log log = LogFactory.getLog(HotRodIntegrationTest.class);
    private static final String CACHE_NAME = "replSync";
    RemoteCache<String, String> defaultRemote;
    RemoteCache<Object, String> remoteCache;
    private RemoteCacheManager remoteCacheManager;
    protected HotRodServer hotrodServer;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = HotRodTestingUtil.hotRodCacheConfiguration((org.infinispan.configuration.cache.ConfigurationBuilder)this.getDefaultStandaloneCacheConfig(false));
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration());
        cm.defineConfiguration(CACHE_NAME, builder.build());
        cm.getCache(CACHE_NAME);
        return cm;
    }

    protected void setup() throws Exception {
        super.setup();
        this.hotrodServer = HotRodClientTestingUtil.startHotRodServer(this.cacheManager);
        log.info((Object)("Started server on port: " + this.hotrodServer.getPort()));
        this.remoteCacheManager = this.getRemoteCacheManager();
        this.defaultRemote = this.remoteCacheManager.getCache();
        this.remoteCache = this.remoteCacheManager.getCache(CACHE_NAME);
    }

    protected RemoteCacheManager getRemoteCacheManager() {
        Properties config = new Properties();
        ConfigurationBuilder clientBuilder = new ConfigurationBuilder();
        clientBuilder.addServer().host("localhost").port(this.hotrodServer.getPort());
        return new RemoteCacheManager(clientBuilder.build());
    }

    @AfterClass
    public void testDestroyRemoteCacheFactory() {
        HotRodClientTestingUtil.killRemoteCacheManager(this.remoteCacheManager);
        HotRodClientTestingUtil.killServers(this.hotrodServer);
    }

    public void testPut() throws Exception {
        assert (null == this.remoteCache.put((Object)"aKey", (Object)"aValue"));
        HotRodTestingUtil.assertHotRodEquals((EmbeddedCacheManager)this.cacheManager, (String)CACHE_NAME, (String)"aKey", (String)"aValue");
        assert (null == this.defaultRemote.put((Object)"otherKey", (Object)"otherValue"));
        HotRodTestingUtil.assertHotRodEquals((EmbeddedCacheManager)this.cacheManager, (String)"otherKey", (String)"otherValue");
        assert (this.remoteCache.containsKey((Object)"aKey"));
        assert (this.defaultRemote.containsKey((Object)"otherKey"));
        assert (((String)this.remoteCache.get((Object)"aKey")).equals("aValue"));
        assert (((String)this.defaultRemote.get((Object)"otherKey")).equals("otherValue"));
    }

    public void testRemove() throws Exception {
        assert (null == this.remoteCache.put((Object)"aKey", (Object)"aValue"));
        HotRodTestingUtil.assertHotRodEquals((EmbeddedCacheManager)this.cacheManager, (String)CACHE_NAME, (String)"aKey", (String)"aValue");
        assert (((String)this.remoteCache.get((Object)"aKey")).equals("aValue"));
        assert (null == this.remoteCache.remove((Object)"aKey"));
        HotRodTestingUtil.assertHotRodEquals((EmbeddedCacheManager)this.cacheManager, (String)CACHE_NAME, (String)"aKey", null);
        assert (!this.remoteCache.containsKey((Object)"aKey"));
    }

    public void testContains() {
        assert (!this.remoteCache.containsKey((Object)"aKey"));
        this.remoteCache.put((Object)"aKey", (Object)"aValue");
        assert (this.remoteCache.containsKey((Object)"aKey"));
    }

    public void testGetVersionedCacheEntry() {
        VersionedValue value = this.remoteCache.getVersioned((Object)"aKey");
        AssertJUnit.assertNull((String)("expected null but received: " + value), (Object)this.remoteCache.getVersioned((Object)"aKey"));
        this.remoteCache.put((Object)"aKey", (Object)"aValue");
        assert (((String)this.remoteCache.get((Object)"aKey")).equals("aValue"));
        VersionedValue valueBinary = this.remoteCache.getVersioned((Object)"aKey");
        assert (valueBinary != null);
        AssertJUnit.assertEquals((Object)valueBinary.getValue(), (Object)"aValue");
        log.info((Object)("Version is: " + valueBinary.getVersion()));
        this.remoteCache.put((Object)"aKey", (Object)"aValue");
        VersionedValue entry2 = this.remoteCache.getVersioned((Object)"aKey");
        AssertJUnit.assertEquals((Object)entry2.getValue(), (Object)"aValue");
        assert (entry2.getVersion() != valueBinary.getVersion());
        assert (!valueBinary.equals(entry2));
        this.remoteCache.put((Object)"aKey", (Object)"anotherValue");
        VersionedValue entry3 = this.remoteCache.getVersioned((Object)"aKey");
        AssertJUnit.assertEquals((Object)entry3.getValue(), (Object)"anotherValue");
        assert (entry3.getVersion() != entry2.getVersion());
        assert (!entry3.equals(entry2));
    }

    public void testGetWithMetadata() {
        MetadataValue value = this.remoteCache.getWithMetadata((Object)"aKey");
        AssertJUnit.assertNull((String)("expected null but received: " + value), (Object)value);
        this.remoteCache.put((Object)"aKey", (Object)"aValue");
        assert (((String)this.remoteCache.get((Object)"aKey")).equals("aValue"));
        MetadataValue immortalValue = this.remoteCache.getWithMetadata((Object)"aKey");
        AssertJUnit.assertNotNull((Object)immortalValue);
        AssertJUnit.assertEquals((Object)"aValue", (Object)immortalValue.getValue());
        AssertJUnit.assertEquals((int)-1, (int)immortalValue.getLifespan());
        AssertJUnit.assertEquals((int)-1, (int)immortalValue.getMaxIdle());
        this.remoteCache.put((Object)"bKey", (Object)"bValue", 60L, TimeUnit.SECONDS);
        MetadataValue mortalValueWithLifespan = this.remoteCache.getWithMetadata((Object)"bKey");
        AssertJUnit.assertNotNull((Object)mortalValueWithLifespan);
        AssertJUnit.assertEquals((Object)"bValue", (Object)mortalValueWithLifespan.getValue());
        AssertJUnit.assertEquals((int)60, (int)mortalValueWithLifespan.getLifespan());
        AssertJUnit.assertEquals((int)-1, (int)mortalValueWithLifespan.getMaxIdle());
        this.remoteCache.put((Object)"cKey", (Object)"cValue", 60L, TimeUnit.SECONDS, 30L, TimeUnit.SECONDS);
        MetadataValue mortalValueWithMaxIdle = this.remoteCache.getWithMetadata((Object)"cKey");
        AssertJUnit.assertNotNull((Object)mortalValueWithMaxIdle);
        AssertJUnit.assertEquals((Object)"cValue", (Object)mortalValueWithMaxIdle.getValue());
        AssertJUnit.assertEquals((int)60, (int)mortalValueWithMaxIdle.getLifespan());
        AssertJUnit.assertEquals((int)30, (int)mortalValueWithMaxIdle.getMaxIdle());
    }

    public void testReplace() {
        assert (null == this.remoteCache.replace((Object)"aKey", (Object)"anotherValue"));
        this.remoteCache.put((Object)"aKey", (Object)"aValue");
        assert (null == this.remoteCache.replace((Object)"aKey", (Object)"anotherValue"));
        assert (((String)this.remoteCache.get((Object)"aKey")).equals("anotherValue"));
    }

    public void testReplaceIfUnmodified() {
        assert (null == this.remoteCache.replace((Object)"aKey", (Object)"aValue"));
        this.remoteCache.put((Object)"aKey", (Object)"aValue");
        VersionedValue valueBinary = this.remoteCache.getVersioned((Object)"aKey");
        assert (this.remoteCache.replaceWithVersion((Object)"aKey", (Object)"aNewValue", valueBinary.getVersion()));
        VersionedValue entry2 = this.remoteCache.getVersioned((Object)"aKey");
        assert (entry2.getVersion() != valueBinary.getVersion());
        AssertJUnit.assertEquals((Object)entry2.getValue(), (Object)"aNewValue");
        assert (!this.remoteCache.replaceWithVersion((Object)"aKey", (Object)"aNewValue", valueBinary.getVersion()));
    }

    public void testReplaceIfUnmodifiedWithExpiry(Method m) throws InterruptedException {
        boolean key = true;
        this.remoteCache.put((Object)1, (Object)TestingUtil.v((Method)m));
        VersionedValue valueBinary = this.remoteCache.getVersioned((Object)1);
        int lifespanSecs = 3;
        long lifespan = TimeUnit.SECONDS.toMillis(lifespanSecs);
        long startTime = System.currentTimeMillis();
        String newValue = TestingUtil.v((Method)m, (int)2);
        assert (this.remoteCache.replaceWithVersion((Object)1, (Object)newValue, valueBinary.getVersion(), lifespanSecs));
        while (true) {
            Object value = this.remoteCache.get((Object)1);
            if (System.currentTimeMillis() >= startTime + lifespan) break;
            AssertJUnit.assertEquals((Object)TestingUtil.v((Method)m, (int)2), (Object)value);
            Thread.sleep(100L);
        }
        while (System.currentTimeMillis() < startTime + lifespan + 2000L && this.remoteCache.get((Object)1) != null) {
            Thread.sleep(50L);
        }
        AssertJUnit.assertNull((Object)this.remoteCache.get((Object)1));
    }

    public void testReplaceWithVersionWithLifespanAsync(Method m) throws Exception {
        int lifespanInSecs = 1;
        String k = TestingUtil.k((Method)m);
        String v = TestingUtil.v((Method)m);
        String newV = TestingUtil.v((Method)m, (int)2);
        AssertJUnit.assertNull((Object)this.remoteCache.replace((Object)k, (Object)v));
        this.remoteCache.put((Object)k, (Object)v);
        VersionedValue valueBinary = this.remoteCache.getVersioned((Object)k);
        long lifespan = TimeUnit.SECONDS.toMillis(lifespanInSecs);
        long startTime = System.currentTimeMillis();
        CompletableFuture future = this.remoteCache.replaceWithVersionAsync((Object)k, (Object)newV, valueBinary.getVersion(), lifespanInSecs);
        assert (((Boolean)future.get()).booleanValue());
        while (true) {
            VersionedValue entry2 = this.remoteCache.getVersioned((Object)k);
            if (System.currentTimeMillis() >= startTime + lifespan) break;
            assert (entry2.getVersion() != valueBinary.getVersion());
            AssertJUnit.assertEquals((Object)newV, (Object)entry2.getValue());
            Thread.sleep(100L);
        }
        while (System.currentTimeMillis() < startTime + lifespan + 2000L && this.remoteCache.get((Object)k) != null) {
            Thread.sleep(50L);
        }
        AssertJUnit.assertNull((Object)this.remoteCache.getVersioned((Object)k));
    }

    public void testRemoveIfUnmodified() {
        assert (!this.remoteCache.removeWithVersion((Object)"aKey", 12321212L));
        this.remoteCache.put((Object)"aKey", (Object)"aValue");
        VersionedValue valueBinary = this.remoteCache.getVersioned((Object)"aKey");
        assert (this.remoteCache.removeWithVersion((Object)"aKey", valueBinary.getVersion()));
        HotRodTestingUtil.assertHotRodEquals((EmbeddedCacheManager)this.cacheManager, (String)CACHE_NAME, (String)"aKey", null);
        this.remoteCache.put((Object)"aKey", (Object)"aNewValue");
        VersionedValue entry2 = this.remoteCache.getVersioned((Object)"aKey");
        assert (entry2.getVersion() != valueBinary.getVersion());
        AssertJUnit.assertEquals((Object)entry2.getValue(), (Object)"aNewValue");
        assert (!this.remoteCache.removeWithVersion((Object)"aKey", valueBinary.getVersion()));
    }

    public void testPutIfAbsent() {
        this.remoteCache.put((Object)"aKey", (Object)"aValue");
        assert (null == this.remoteCache.putIfAbsent((Object)"aKey", (Object)"anotherValue"));
        AssertJUnit.assertEquals((String)((String)this.remoteCache.get((Object)"aKey")), (String)"aValue");
        AssertJUnit.assertEquals((String)((String)this.remoteCache.get((Object)"aKey")), (String)"aValue");
        assert (this.remoteCache.containsKey((Object)"aKey"));
    }

    public void testClear() {
        this.remoteCache.put((Object)"aKey", (Object)"aValue");
        this.remoteCache.put((Object)"aKey2", (Object)"aValue");
        this.remoteCache.clear();
        assert (!this.remoteCache.containsKey((Object)"aKey"));
        assert (!this.remoteCache.containsKey((Object)"aKey2"));
        assert (this.cache.isEmpty());
    }

    public void testPutWithPrevious() {
        assert (null == this.remoteCache.put((Object)"aKey", (Object)"aValue"));
        assert ("aValue".equals(this.remoteCache.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).put((Object)"aKey", (Object)"otherValue")));
        assert (this.remoteCache.containsKey((Object)"aKey"));
        assert (((String)this.remoteCache.get((Object)"aKey")).equals("otherValue"));
    }

    public void testRemoveWithPrevious() {
        assert (null == this.remoteCache.put((Object)"aKey", (Object)"aValue"));
        assert (((String)this.remoteCache.get((Object)"aKey")).equals("aValue"));
        assert ("aValue".equals(this.remoteCache.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).remove((Object)"aKey")));
        assert (!this.remoteCache.containsKey((Object)"aKey"));
    }

    public void testRemoveNonExistForceReturnPrevious() {
        AssertJUnit.assertNull((Object)this.remoteCache.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).remove((Object)"aKey"));
        this.remoteCache.put((Object)"k", (Object)"v");
    }

    public void testReplaceWithPrevious() {
        assert (null == this.remoteCache.replace((Object)"aKey", (Object)"anotherValue"));
        this.remoteCache.put((Object)"aKey", (Object)"aValue");
        assert ("aValue".equals(this.remoteCache.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).replace((Object)"aKey", (Object)"anotherValue")));
        assert (((String)this.remoteCache.get((Object)"aKey")).equals("anotherValue"));
    }

    public void testPutIfAbsentWithPrevious() {
        this.remoteCache.put((Object)"aKey", (Object)"aValue");
        assert (null == this.remoteCache.putIfAbsent((Object)"aKey", (Object)"anotherValue"));
        Object existingValue = this.remoteCache.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).putIfAbsent((Object)"aKey", (Object)"anotherValue");
        assert ("aValue".equals(existingValue)) : "Existing value was:" + existingValue;
    }

    public void testPutSerializableByteArray() {
        RemoteCache binaryRemote = this.remoteCacheManager.getCache();
        byte[] bytes = this.serializeObject(new MyValue<String>("aValue"));
        binaryRemote.put((Object)"aKey", (Object)bytes);
        ArrayAsserts.assertArrayEquals((byte[])bytes, (byte[])((byte[])binaryRemote.get((Object)"aKey")));
    }

    private byte[] serializeObject(Object obj) {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        try {
            ObjectOutputStream os = new ObjectOutputStream(bs);
            os.writeObject(obj);
            os.close();
            return bs.toByteArray();
        }
        catch (IOException ioe) {
            throw new AssertionError((Object)ioe);
        }
    }

    static class MyValue<V>
    implements Serializable {
        final V value;

        MyValue(V value) {
            this.value = value;
        }
    }
}

