/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.SslConfigurationBuilder;
import org.infinispan.client.hotrod.exceptions.TransportException;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.SslTest", groups={"functional"})
@CleanupAfterMethod
public class SslTest
extends SingleCacheManagerTest {
    private static final Log log = LogFactory.getLog(SslTest.class);
    public static final char[] STORE_PASSWORD = "secret".toCharArray();
    public static final char[] ALT_CERTIFICATE_PASSWORD = "changeme".toCharArray();
    RemoteCache<String, String> defaultRemote;
    protected RemoteCacheManager remoteCacheManager;
    protected HotRodServer hotrodServer;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        this.cacheManager = TestCacheManagerFactory.createCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration());
        this.cacheManager.getCache();
        return this.cacheManager;
    }

    protected void initServerAndClient(boolean sslServer, boolean sslClient, boolean requireClientAuth, boolean clientAuth, boolean altCertPassword) {
        this.hotrodServer = new HotRodServer();
        HotRodServerConfigurationBuilder serverBuilder = HotRodTestingUtil.getDefaultHotRodConfiguration();
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        String serverKeyStore = tccl.getResource(altCertPassword ? "keystore_server_alt_cert_password.jks" : "keystore_server.jks").getPath();
        String serverTrustStore = tccl.getResource("truststore_server.jks").getPath();
        org.infinispan.server.core.configuration.SslConfigurationBuilder serverSSLConfig = serverBuilder.ssl().enabled(sslServer).keyStoreFileName(serverKeyStore).keyStorePassword(STORE_PASSWORD);
        if (altCertPassword) {
            serverSSLConfig.keyStoreCertificatePassword(ALT_CERTIFICATE_PASSWORD);
        }
        if (requireClientAuth) {
            serverSSLConfig.requireClientAuth(true).trustStoreFileName(serverTrustStore).trustStorePassword(STORE_PASSWORD);
        }
        this.hotrodServer.start((ProtocolServerConfiguration)serverBuilder.build(), this.cacheManager);
        log.info((Object)("Started server on port: " + this.hotrodServer.getPort()));
        String clientKeyStore = tccl.getResource(altCertPassword ? "keystore_client_alt_cert_password.jks" : "keystore_client.jks").getPath();
        String clientTrustStore = tccl.getResource("truststore_client.jks").getPath();
        ConfigurationBuilder clientBuilder = new ConfigurationBuilder();
        SslConfigurationBuilder clientSSLConfig = clientBuilder.addServer().host("127.0.0.1").port(this.hotrodServer.getPort()).socketTimeout(3000).connectionPool().maxActive(1).timeBetweenEvictionRuns(2000L).security().authentication().disable().ssl().enabled(sslClient).trustStoreFileName(clientTrustStore).trustStorePassword(STORE_PASSWORD);
        if (clientAuth) {
            clientSSLConfig.keyStoreFileName(clientKeyStore).keyStorePassword(STORE_PASSWORD);
            if (altCertPassword) {
                clientSSLConfig.keyStoreCertificatePassword(ALT_CERTIFICATE_PASSWORD);
            }
        }
        this.remoteCacheManager = new RemoteCacheManager(clientBuilder.build());
        this.defaultRemote = this.remoteCacheManager.getCache();
    }

    protected void teardown() {
        HotRodClientTestingUtil.killRemoteCacheManager(this.remoteCacheManager);
        HotRodClientTestingUtil.killServers(this.hotrodServer);
        super.teardown();
    }

    public void testSSLServerSSLClient() throws Exception {
        this.initServerAndClient(true, true, false, false, false);
        this.defaultRemote.put((Object)"k", (Object)"v");
        AssertJUnit.assertEquals((String)"v", (String)((String)this.defaultRemote.get((Object)"k")));
    }

    @Test(expectedExceptions={TransportException.class})
    public void testSSLServerPlainClient() throws Exception {
        this.initServerAndClient(true, false, false, false, false);
    }

    @Test(expectedExceptions={TransportException.class})
    public void testPlainServerSSLClient() throws Exception {
        this.initServerAndClient(false, true, false, false, false);
    }

    public void testClientAuth() throws Exception {
        this.initServerAndClient(true, true, true, true, false);
        this.defaultRemote.put((Object)"k", (Object)"v");
        AssertJUnit.assertEquals((String)"v", (String)((String)this.defaultRemote.get((Object)"k")));
    }

    @Test(expectedExceptions={TransportException.class}, expectedExceptionsMessageRegExp="javax.net.ssl.SSLHandshakeException.*")
    public void testClientAuthWithAnonClient() throws Exception {
        this.initServerAndClient(true, true, true, false, false);
    }

    public void testClientAuthAltCertPassowrd() throws Exception {
        this.initServerAndClient(true, true, true, true, true);
        this.defaultRemote.put((Object)"k", (Object)"v");
        AssertJUnit.assertEquals((String)"v", (String)((String)this.defaultRemote.get((Object)"k")));
    }
}

