/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.marshall;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.infinispan.protostream.MessageMarshaller;
import org.infinispan.query.dsl.embedded.testdomain.User;
import org.infinispan.query.dsl.embedded.testdomain.hsearch.AddressHS;
import org.infinispan.query.dsl.embedded.testdomain.hsearch.UserHS;

public class EmbeddedUserMarshaller
implements MessageMarshaller<UserHS> {
    public String getTypeName() {
        return "sample_bank_account.User";
    }

    public Class<UserHS> getJavaClass() {
        return UserHS.class;
    }

    public UserHS readFrom(MessageMarshaller.ProtoStreamReader reader) throws IOException {
        int id = reader.readInt("id");
        Set accountIds = (Set)reader.readCollection("accountIds", new HashSet(), Integer.class);
        String surname = reader.readString("surname");
        String name = reader.readString("name");
        List addresses = (List)reader.readCollection("addresses", new ArrayList(), AddressHS.class);
        Integer age = reader.readInt("age");
        User.Gender gender = (User.Gender)reader.readEnum("gender", User.Gender.class);
        String notes = reader.readString("notes");
        Instant creationDate = reader.readInstant("creationDate");
        Instant passwordExpirationDate = reader.readInstant("passwordExpirationDate");
        UserHS user = new UserHS();
        user.setId(id);
        user.setAccountIds(accountIds);
        user.setName(name);
        user.setSurname(surname);
        user.setAge(age);
        user.setGender(gender);
        user.setAddresses(addresses);
        user.setNotes(notes);
        user.setCreationDate(creationDate);
        user.setPasswordExpirationDate(passwordExpirationDate);
        return user;
    }

    public void writeTo(MessageMarshaller.ProtoStreamWriter writer, UserHS user) throws IOException {
        writer.writeInt("id", user.getId());
        writer.writeCollection("accountIds", (Collection)user.getAccountIds(), Integer.class);
        writer.writeString("name", user.getName());
        writer.writeString("surname", user.getSurname());
        writer.writeCollection("addresses", (Collection)user.getAddresses(), AddressHS.class);
        writer.writeInt("age", user.getAge());
        writer.writeEnum("gender", (Enum)user.getGender(), User.Gender.class);
        writer.writeString("notes", user.getNotes());
        writer.writeInstant("creationDate", user.getCreationDate());
        writer.writeInstant("passwordExpirationDate", user.getPasswordExpirationDate());
    }
}

