/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.stress;

import java.net.SocketAddress;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.impl.consistenthash.ConsistentHash;
import org.infinispan.client.hotrod.impl.transport.tcp.TcpTransportFactory;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.test.TestingUtil;
import org.testng.annotations.Test;

@Test(groups={"profiling"}, testName="client.hotrod.stress.ClientConsistentHashPerfTest")
public class ClientConsistentHashPerfTest
extends MultiHotRodServersTest {
    private static final int NUM_SERVERS = 64;
    private static final int ITERATIONS = 10000000;
    private static final int NUM_KEYS = 100000;

    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder config = ClientConsistentHashPerfTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false);
        this.createHotRodServers(64, config);
    }

    public void testConsistentHashPerf() throws Exception {
        RemoteCacheManager rcm = this.client(0);
        RemoteCache cache = rcm.getCache();
        cache.put((Object)"k", (Object)"v");
        TcpTransportFactory transportFactory = (TcpTransportFactory)TestingUtil.extractField((Object)rcm, (String)"transportFactory");
        ConsistentHash ch = transportFactory.getConsistentHash(RemoteCacheManager.cacheNameBytes());
        byte[][] keys = new byte[100000][];
        for (int i = 0; i < 100000; ++i) {
            keys[i] = String.valueOf(i).getBytes("UTF-8");
        }
        SocketAddress aServer = null;
        for (int i = 0; i < 1000000; ++i) {
            SocketAddress server = ch.getServer((Object)keys[i % keys.length]);
            if (server == null) continue;
            aServer = server;
        }
        long startNanos = System.nanoTime();
        for (int i = 0; i < 10000000; ++i) {
            SocketAddress server = ch.getServer((Object)keys[i % keys.length]);
            if (server == null) continue;
            aServer = server;
        }
        double duration = System.nanoTime() - startNanos;
        this.log.infof("Test took %.3f s, average CH lookup was %.3f ns", (Object)(duration / 1.0E9), (Object)(duration / 1.0E7));
    }
}

