/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.remoting.rpc.RpcManagerImpl;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.CompatRoutingTest", groups={"functional"})
public class CompatRoutingTest
extends MultiHotRodServersTest {
    protected void createCacheManagers() throws Throwable {
        this.createHotRodServers(2, this.getCacheConfiguration());
    }

    private ConfigurationBuilder getCacheConfiguration() {
        ConfigurationBuilder builder = CompatRoutingTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false);
        builder.clustering().hash().numOwners(1).compatibility().enabled(true);
        builder.jmxStatistics().enable();
        return builder;
    }

    public void testGetWithCompatibility() {
        RemoteCache client = this.client(0).getCache();
        HashMap cachedValues = new HashMap();
        for (int i = 0; i < 100; ++i) {
            Iterator key = String.format("key-%d", i);
            String value = String.format("value-%d", i);
            client.put(key, (Object)value);
            cachedValues.put(key, value);
        }
        int startRpcs = 0;
        for (Cache cache : this.caches()) {
            startRpcs = (int)((long)startRpcs + ((RpcManagerImpl)cache.getAdvancedCache().getRpcManager()).getReplicationCount());
        }
        AssertJUnit.assertTrue((startRpcs > 0 ? 1 : 0) != 0);
        for (Map.Entry entry : cachedValues.entrySet()) {
            String value = (String)client.get(entry.getKey());
            AssertJUnit.assertEquals((String)((String)entry.getValue()), (String)value);
        }
        int endRpcs = 0;
        for (Cache cache : this.caches()) {
            endRpcs = (int)((long)endRpcs + ((RpcManagerImpl)cache.getAdvancedCache().getRpcManager()).getReplicationCount());
        }
        AssertJUnit.assertEquals((int)startRpcs, (int)endRpcs);
    }
}

