/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.net.InetSocketAddress;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.impl.transport.tcp.TcpTransport;
import org.infinispan.client.hotrod.impl.transport.tcp.TcpTransportFactory;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.InternalRemoteCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.DroppedConnectionsTest", groups={"functional"})
public class DroppedConnectionsTest
extends SingleCacheManagerTest {
    private HotRodServer hotRodServer;
    private RemoteCacheManager remoteCacheManager;
    private RemoteCache rc;
    private TcpTransportFactory transportFactory;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        this.cacheManager = TestCacheManagerFactory.createCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration((org.infinispan.configuration.cache.ConfigurationBuilder)this.getDefaultStandaloneCacheConfig(false)));
        this.hotRodServer = HotRodClientTestingUtil.startHotRodServer(this.cacheManager);
        ConfigurationBuilder clientBuilder = new ConfigurationBuilder();
        clientBuilder.connectionPool().testWhileIdle(false).minIdle(1).maxIdle(2).maxActive(2).addServer().host("localhost").port(this.hotRodServer.getPort());
        this.remoteCacheManager = new InternalRemoteCacheManager(clientBuilder.build());
        this.rc = this.remoteCacheManager.getCache();
        this.transportFactory = (TcpTransportFactory)((InternalRemoteCacheManager)this.remoteCacheManager).getTransportFactory();
        return this.cacheManager;
    }

    @AfterClass
    protected void teardown() {
        super.teardown();
        HotRodClientTestingUtil.killRemoteCacheManager(this.remoteCacheManager);
        HotRodClientTestingUtil.killServers(this.hotRodServer);
    }

    public void testClosedConnection() throws Exception {
        this.rc.put((Object)"k", (Object)"v");
        GenericKeyedObjectPool keyedObjectPool = this.transportFactory.getConnectionPool();
        InetSocketAddress address = new InetSocketAddress("127.0.0.1", this.hotRodServer.getPort());
        AssertJUnit.assertEquals((int)0, (int)keyedObjectPool.getNumActive((Object)address));
        AssertJUnit.assertEquals((int)1, (int)keyedObjectPool.getNumIdle((Object)address));
        TcpTransport tcpConnection = (TcpTransport)keyedObjectPool.borrowObject((Object)address);
        keyedObjectPool.returnObject((Object)address, (Object)tcpConnection);
        tcpConnection.release();
        AssertJUnit.assertEquals((Object)"v", (Object)this.rc.get((Object)"k"));
        AssertJUnit.assertEquals((int)0, (int)keyedObjectPool.getNumActive((Object)address));
        AssertJUnit.assertEquals((int)1, (int)keyedObjectPool.getNumIdle((Object)address));
        TcpTransport tcpConnection2 = (TcpTransport)keyedObjectPool.borrowObject((Object)address);
        assert (tcpConnection2.getId() != tcpConnection.getId());
    }
}

