/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.net.InetSocketAddress;
import java.util.Collection;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.impl.transport.tcp.TcpTransportFactory;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.InternalRemoteCacheManager;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.ReplTopologyChangeTest", groups={"functional"})
public class ReplTopologyChangeTest
extends MultipleCacheManagersTest {
    HotRodServer hotRodServer1;
    HotRodServer hotRodServer2;
    HotRodServer hotRodServer3;
    RemoteCache remoteCache;
    private RemoteCacheManager remoteCacheManager;
    private TcpTransportFactory tcpTransportFactory;
    private org.infinispan.configuration.cache.ConfigurationBuilder config;

    @AfterMethod
    protected void clearContent() throws Throwable {
    }

    @AfterClass
    protected void destroy() {
        super.destroy();
        HotRodClientTestingUtil.killServers(this.hotRodServer1, this.hotRodServer2);
        HotRodClientTestingUtil.killRemoteCacheManager(this.remoteCacheManager);
    }

    protected void createCacheManagers() throws Throwable {
        this.config = HotRodTestingUtil.hotRodCacheConfiguration((org.infinispan.configuration.cache.ConfigurationBuilder)ReplTopologyChangeTest.getDefaultClusteredCacheConfig((CacheMode)this.getCacheMode(), (boolean)false));
        EmbeddedCacheManager cm1 = TestCacheManagerFactory.createClusteredCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)this.config);
        EmbeddedCacheManager cm2 = TestCacheManagerFactory.createClusteredCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)this.config);
        this.registerCacheManager(new CacheContainer[]{cm1});
        this.registerCacheManager(new CacheContainer[]{cm2});
        this.waitForClusterToForm();
    }

    @BeforeClass
    public void createBeforeClass() throws Throwable {
        super.createBeforeClass();
        this.hotRodServer1 = HotRodClientTestingUtil.startHotRodServer(this.manager(0));
        this.hotRodServer2 = HotRodClientTestingUtil.startHotRodServer(this.manager(1));
        ConfigurationBuilder clientBuilder = new ConfigurationBuilder();
        clientBuilder.addServer().host("localhost").port(this.hotRodServer2.getPort());
        this.remoteCacheManager = new InternalRemoteCacheManager(clientBuilder.build());
        this.remoteCache = this.remoteCacheManager.getCache();
        this.tcpTransportFactory = (TcpTransportFactory)((InternalRemoteCacheManager)this.remoteCacheManager).getTransportFactory();
    }

    protected CacheMode getCacheMode() {
        return CacheMode.REPL_SYNC;
    }

    public void testTwoMembers() {
        InetSocketAddress server1Address = new InetSocketAddress("localhost", this.hotRodServer1.getPort());
        this.expectTopologyChange(server1Address, true);
        AssertJUnit.assertEquals((int)2, (int)this.tcpTransportFactory.getServers().size());
    }

    @Test(dependsOnMethods={"testTwoMembers"})
    public void testAddNewServer() {
        EmbeddedCacheManager cm3 = TestCacheManagerFactory.createClusteredCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)this.config);
        this.registerCacheManager(new CacheContainer[]{cm3});
        this.hotRodServer3 = HotRodClientTestingUtil.startHotRodServer(this.manager(2));
        this.manager(2).getCache();
        this.waitForClusterToForm();
        try {
            this.expectTopologyChange(new InetSocketAddress("localhost", this.hotRodServer3.getPort()), true);
            AssertJUnit.assertEquals((int)3, (int)this.tcpTransportFactory.getServers().size());
        }
        finally {
            this.log.info((Object)("Members are: " + this.manager(0).getCache().getAdvancedCache().getRpcManager().getTransport().getMembers()));
            this.log.info((Object)("Members are: " + this.manager(1).getCache().getAdvancedCache().getRpcManager().getTransport().getMembers()));
            this.log.info((Object)("Members are: " + this.manager(2).getCache().getAdvancedCache().getRpcManager().getTransport().getMembers()));
        }
    }

    @Test(dependsOnMethods={"testAddNewServer"})
    public void testDropServer() {
        this.hotRodServer3.stop();
        this.manager(2).stop();
        this.log.trace((Object)"Just stopped server 2");
        this.waitForServerToDie(2);
        InetSocketAddress server3Address = new InetSocketAddress("localhost", this.hotRodServer3.getPort());
        try {
            this.expectTopologyChange(server3Address, false);
            AssertJUnit.assertEquals((int)2, (int)this.tcpTransportFactory.getServers().size());
        }
        finally {
            this.log.info((Object)("Members are: " + this.manager(0).getCache().getAdvancedCache().getRpcManager().getTransport().getMembers()));
            this.log.info((Object)("Members are: " + this.manager(1).getCache().getAdvancedCache().getRpcManager().getTransport().getMembers()));
            if (this.manager(2).getStatus() != ComponentStatus.RUNNING) {
                this.log.info((Object)"Members are: 0");
            } else {
                this.log.info((Object)("Members are: " + this.manager(2).getCache().getAdvancedCache().getRpcManager().getTransport().getMembers()));
            }
        }
    }

    private void expectTopologyChange(InetSocketAddress server1Address, boolean added) {
        for (int i = 0; i < 10; ++i) {
            this.remoteCache.put((Object)("k" + i), (Object)("v" + i));
            if (added == this.tcpTransportFactory.getServers().contains(server1Address)) break;
        }
        Collection addresses = this.tcpTransportFactory.getServers();
        AssertJUnit.assertEquals((String)(server1Address + " not found in " + addresses), (boolean)added, (boolean)addresses.contains(server1Address));
    }

    protected void waitForServerToDie(int memberCount) {
        TestingUtil.blockUntilViewReceived((Cache)this.manager(0).getCache(), (int)memberCount, (long)30000L, (boolean)false);
    }
}

