/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.net.SocketAddress;
import java.util.Map;
import java.util.Set;
import org.infinispan.client.hotrod.BaseSegmentOwnershipTest;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.configuration.cache.CacheMode;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.SegmentOwnershipDistTest")
public class SegmentOwnershipDistTest
extends BaseSegmentOwnershipTest {
    public void testObtainSegmentOwnership() throws Exception {
        RemoteCache remoteCache = this.client(0).getCache();
        Map segmentsByServer = remoteCache.getCacheTopologyInfo().getSegmentsPerServer();
        Map<Integer, Set<SocketAddress>> serversBySegment = this.invertMap(segmentsByServer);
        Assert.assertEquals((int)segmentsByServer.keySet().size(), (int)3);
        Assert.assertTrue((boolean)serversBySegment.entrySet().stream().allMatch(e -> ((Set)e.getValue()).size() == 2));
    }

    @Override
    protected CacheMode getCacheMode() {
        return CacheMode.DIST_SYNC;
    }
}

