/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.lang.reflect.Method;
import java.util.Properties;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvent;
import org.infinispan.remoting.transport.jgroups.SuspectException;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.ServerErrorTest")
public class ServerErrorTest
extends SingleCacheManagerTest {
    private HotRodServer hotrodServer;
    private RemoteCacheManager remoteCacheManager;
    private RemoteCache<String, String> remoteCache;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        this.cacheManager = TestCacheManagerFactory.createCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration());
        this.hotrodServer = HotRodClientTestingUtil.startHotRodServer(this.cacheManager);
        this.remoteCacheManager = this.getRemoteCacheManager();
        this.remoteCache = this.remoteCacheManager.getCache();
        return this.cacheManager;
    }

    protected RemoteCacheManager getRemoteCacheManager() {
        Properties config = new Properties();
        ConfigurationBuilder clientBuilder = new ConfigurationBuilder();
        clientBuilder.addServer().host("localhost").port(this.hotrodServer.getPort());
        return new RemoteCacheManager(clientBuilder.build());
    }

    @AfterClass
    public void shutDownHotrod() {
        HotRodClientTestingUtil.killRemoteCacheManager(this.remoteCacheManager);
        HotRodClientTestingUtil.killServers(this.hotrodServer);
    }

    public void testErrorWhileDoingPut(Method m) throws Exception {
        this.cache.addListener((Object)new ErrorInducingListener());
        this.remoteCache = this.remoteCacheManager.getCache();
        this.remoteCache.put((Object)TestingUtil.k((Method)m), (Object)TestingUtil.v((Method)m));
        assert (((String)this.remoteCache.get((Object)TestingUtil.k((Method)m))).equals(TestingUtil.v((Method)m)));
        try {
            this.remoteCache.put((Object)"FailFailFail", (Object)"whatever...");
        }
        catch (HotRodClientException hotRodClientException) {
            // empty catch block
        }
        try {
            this.remoteCache.put((Object)TestingUtil.k((Method)m, (int)2), (Object)TestingUtil.v((Method)m, (int)2));
            assert (((String)this.remoteCache.get((Object)TestingUtil.k((Method)m, (int)2))).equals(TestingUtil.v((Method)m, (int)2)));
        }
        catch (Exception e) {
            this.log.error((Object)"Error sending request after server failure", (Throwable)e);
            throw e;
        }
    }

    @Listener
    public static class ErrorInducingListener {
        @CacheEntryCreated
        public void entryCreated(CacheEntryEvent<byte[], byte[]> event) throws Exception {
            if (event.isPre() && HotRodTestingUtil.unmarshall((byte[])((byte[])event.getKey())) == "FailFailFail") {
                throw new SuspectException("Simulated suspicion");
            }
        }
    }
}

