/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.util.HashMap;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.interceptors.base.BaseCustomInterceptor;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.CleanupAfterTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.SkipCacheLoadFlagTest", groups={"functional"})
@CleanupAfterTest
public class SkipCacheLoadFlagTest
extends SingleCacheManagerTest {
    private static final String KEY = "key";
    private static final String VALUE = "value";
    private FlagCheckCommandInterceptor commandInterceptor;
    private RemoteCache<String, String> remoteCache;
    private RemoteCacheManager remoteCacheManager;
    private HotRodServer hotRodServer;

    public void testPut() {
        this.performTest(RequestType.PUT);
    }

    public void testReplace() {
        this.performTest(RequestType.REPLACE);
    }

    public void testPutIfAbsent() {
        this.performTest(RequestType.PUT_IF_ABSENT);
    }

    public void testReplaceIfUnmodified() {
        this.performTest(RequestType.REPLACE_IF_UNMODIFIED);
    }

    public void testGet() {
        this.performTest(RequestType.GET);
    }

    public void testGetWithVersion() {
        this.performTest(RequestType.GET_WITH_VERSION);
    }

    public void testGetWithMetadata() {
        this.performTest(RequestType.GET_WITH_METADATA);
    }

    public void testRemove() {
        this.performTest(RequestType.REMOVE);
    }

    public void testRemoveIfUnmodified() {
        this.performTest(RequestType.REMOVE_IF_UNMODIFIED);
    }

    public void testContainsKey() {
        this.performTest(RequestType.CONTAINS);
    }

    public void testPutAll() {
        this.performTest(RequestType.PUT_ALL);
    }

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        this.cacheManager = TestCacheManagerFactory.createCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration());
        this.cache = this.cacheManager.getCache();
        this.hotRodServer = HotRodClientTestingUtil.startHotRodServer(this.cacheManager);
        ConfigurationBuilder clientBuilder = new ConfigurationBuilder();
        clientBuilder.addServer().host("localhost").port(this.hotRodServer.getPort());
        this.remoteCacheManager = new RemoteCacheManager(clientBuilder.build());
        this.remoteCache = this.remoteCacheManager.getCache();
        return this.cacheManager;
    }

    protected void teardown() {
        HotRodClientTestingUtil.killRemoteCacheManager(this.remoteCacheManager);
        HotRodClientTestingUtil.killServers(this.hotRodServer);
        super.teardown();
    }

    private void performTest(RequestType type) {
        this.commandInterceptor.expectSkipLoadFlag = false;
        type.execute(this.remoteCache);
        this.commandInterceptor.expectSkipLoadFlag = RequestType.expectsFlag(type);
        type.execute((RemoteCache<String, String>)this.remoteCache.withFlags(new Flag[]{Flag.SKIP_CACHE_LOAD}));
        type.execute((RemoteCache<String, String>)this.remoteCache.withFlags(new Flag[]{Flag.SKIP_CACHE_LOAD, Flag.FORCE_RETURN_VALUE}));
    }

    @BeforeClass(alwaysRun=true)
    private void injectCommandInterceptor() {
        if (this.remoteCache == null) {
            return;
        }
        for (CommandInterceptor commandInterceptor : this.cache.getAdvancedCache().getInterceptorChain()) {
            if (!(commandInterceptor instanceof FlagCheckCommandInterceptor)) continue;
            this.commandInterceptor = (FlagCheckCommandInterceptor)commandInterceptor;
        }
        this.commandInterceptor = new FlagCheckCommandInterceptor();
        this.cache.getAdvancedCache().addInterceptor((CommandInterceptor)this.commandInterceptor, 1);
    }

    @AfterClass(alwaysRun=true)
    private void resetCommandInterceptor() {
        if (this.commandInterceptor != null) {
            this.commandInterceptor.expectSkipLoadFlag = false;
        }
    }

    private static class FlagCheckCommandInterceptor
    extends BaseCustomInterceptor {
        private volatile boolean expectSkipLoadFlag;

        private FlagCheckCommandInterceptor() {
        }

        protected Object handleDefault(InvocationContext ctx, VisitableCommand command) throws Throwable {
            if (command instanceof FlagAffectedCommand) {
                boolean hasFlag = ((FlagAffectedCommand)command).hasAnyFlag(FlagBitSets.SKIP_CACHE_LOAD);
                if (this.expectSkipLoadFlag && !hasFlag) {
                    throw new CacheException("SKIP_CACHE_LOAD flag is expected!");
                }
                if (!this.expectSkipLoadFlag && hasFlag) {
                    throw new CacheException("SKIP_CACHE_LOAD flag is *not* expected!");
                }
            }
            return super.handleDefault(ctx, command);
        }
    }

    private static enum RequestType {
        PUT{

            @Override
            void execute(RemoteCache<String, String> cache) {
                cache.put((Object)SkipCacheLoadFlagTest.KEY, (Object)SkipCacheLoadFlagTest.VALUE);
            }
        }
        ,
        REPLACE{

            @Override
            void execute(RemoteCache<String, String> cache) {
                cache.replace((Object)SkipCacheLoadFlagTest.KEY, (Object)SkipCacheLoadFlagTest.VALUE);
            }
        }
        ,
        PUT_IF_ABSENT{

            @Override
            void execute(RemoteCache<String, String> cache) {
                cache.putIfAbsent((Object)SkipCacheLoadFlagTest.KEY, (Object)SkipCacheLoadFlagTest.VALUE);
            }
        }
        ,
        REPLACE_IF_UNMODIFIED{

            @Override
            void execute(RemoteCache<String, String> cache) {
                cache.replaceWithVersion((Object)SkipCacheLoadFlagTest.KEY, (Object)SkipCacheLoadFlagTest.VALUE, 0L);
            }
        }
        ,
        GET{

            @Override
            void execute(RemoteCache<String, String> cache) {
                cache.get((Object)SkipCacheLoadFlagTest.KEY);
            }
        }
        ,
        GET_WITH_VERSION{

            @Override
            void execute(RemoteCache<String, String> cache) {
                cache.getVersioned((Object)SkipCacheLoadFlagTest.KEY);
            }
        }
        ,
        GET_WITH_METADATA{

            @Override
            void execute(RemoteCache<String, String> cache) {
                cache.getWithMetadata((Object)SkipCacheLoadFlagTest.KEY);
            }
        }
        ,
        REMOVE{

            @Override
            void execute(RemoteCache<String, String> cache) {
                cache.remove((Object)SkipCacheLoadFlagTest.KEY);
            }
        }
        ,
        REMOVE_IF_UNMODIFIED{

            @Override
            void execute(RemoteCache<String, String> cache) {
                cache.removeWithVersion((Object)SkipCacheLoadFlagTest.KEY, 0L);
            }
        }
        ,
        CONTAINS{

            @Override
            void execute(RemoteCache<String, String> cache) {
                cache.containsKey((Object)SkipCacheLoadFlagTest.KEY);
            }
        }
        ,
        PUT_ALL{

            @Override
            void execute(RemoteCache<String, String> cache) {
                HashMap<String, String> data = new HashMap<String, String>();
                data.put(SkipCacheLoadFlagTest.KEY, SkipCacheLoadFlagTest.VALUE);
                cache.putAll(data);
            }
        };


        private static boolean expectsFlag(RequestType type) {
            return type != PUT_IF_ABSENT && type != REMOVE_IF_UNMODIFIED && type != REPLACE && type != REPLACE_IF_UNMODIFIED;
        }

        abstract void execute(RemoteCache<String, String> var1);
    }
}

