/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.lang.reflect.Method;
import java.net.SocketTimeoutException;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.SingleHotRodServerTest;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commons.marshall.WrappedByteArray;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.interceptors.impl.EntryWrappingInterceptor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.core.JBossMarshaller;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.SocketTimeoutErrorTest")
public class SocketTimeoutErrorTest
extends SingleHotRodServerTest {
    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = new org.infinispan.configuration.cache.ConfigurationBuilder();
        builder.customInterceptors().addInterceptor().interceptor((CommandInterceptor)new TimeoutInducingInterceptor()).after(EntryWrappingInterceptor.class);
        return TestCacheManagerFactory.createCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration((org.infinispan.configuration.cache.ConfigurationBuilder)builder));
    }

    @Override
    protected HotRodServer createHotRodServer() {
        HotRodServerConfigurationBuilder builder = new HotRodServerConfigurationBuilder();
        builder.workerThreads(6);
        return HotRodClientTestingUtil.startHotRodServer(this.cacheManager, builder);
    }

    @Override
    protected RemoteCacheManager getRemoteCacheManager() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.addServer().host("127.0.0.1").port(this.hotrodServer.getPort());
        builder.socketTimeout(2000);
        builder.maxRetries(0);
        return new RemoteCacheManager(builder.build());
    }

    public void testErrorWhileDoingPut(Method m) throws Exception {
        RemoteCache cache;
        block2: {
            cache = this.remoteCacheManager.getCache();
            cache.put((Object)TestingUtil.k((Method)m), (Object)1);
            AssertJUnit.assertEquals((int)1, (int)((Integer)cache.get((Object)TestingUtil.k((Method)m))));
            try {
                cache.put((Object)"FailFailFail", (Object)2);
                Assert.fail((String)"No exception was thrown.");
            }
            catch (HotRodClientException e) {
                if ($assertionsDisabled || e.getCause() instanceof SocketTimeoutException) break block2;
                throw new AssertionError();
            }
        }
        cache.put((Object)"dos", (Object)2);
        AssertJUnit.assertEquals((int)2, (int)((Integer)cache.get((Object)"dos")));
    }

    public static class TimeoutInducingInterceptor
    extends CommandInterceptor {
        public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
            if (this.unmarshall(command.getKey()).equals("FailFailFail")) {
                Thread.sleep(6000L);
                return null;
            }
            return super.visitPutKeyValueCommand(ctx, command);
        }

        private String unmarshall(Object key) throws Exception {
            JBossMarshaller marshaller = new JBossMarshaller();
            return (String)marshaller.objectFromByteBuffer(((WrappedByteArray)key).getBytes());
        }
    }
}

