/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.configuration;

import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import javax.net.ssl.SSLContext;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.infinispan.client.hotrod.SomeAsyncExecutorFactory;
import org.infinispan.client.hotrod.SomeCustomConsistentHashV2;
import org.infinispan.client.hotrod.SomeRequestBalancingStrategy;
import org.infinispan.client.hotrod.SomeTransportfactory;
import org.infinispan.client.hotrod.configuration.ClusterConfiguration;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.ExhaustedAction;
import org.infinispan.client.hotrod.configuration.ServerConfiguration;
import org.infinispan.client.hotrod.impl.transport.tcp.SaslTransportObjectFactory;
import org.infinispan.client.hotrod.marshall.ProtoStreamMarshaller;
import org.infinispan.client.hotrod.security.BasicCallbackHandler;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.util.FileLookupFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.configuration.ConfigurationTest", groups={"functional"})
public class ConfigurationTest {
    static final Map<String, Function<Configuration, ?>> OPTIONS = new HashMap();
    static final Map<Class<?>, Function<Object, Object>> TYPES = new HashMap();
    CallbackHandler callbackHandler = new MyCallbackHandler();
    Subject clientSubject = new Subject();

    public void testConfiguration() {
        HashMap<String, String> saslProperties = new HashMap<String, String>();
        saslProperties.put("A", "1");
        saslProperties.put("B", "2");
        saslProperties.put("C", "3");
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.addServer().host("host1").port(11222).addServer().host("host2").port(11222).asyncExecutorFactory().factoryClass(SomeAsyncExecutorFactory.class).balancingStrategy(SomeRequestBalancingStrategy.class).connectionPool().maxActive(100).maxTotal(150).maxWait(1000L).maxIdle(20).minIdle(10).exhaustedAction(ExhaustedAction.WAIT).numTestsPerEvictionRun(5).testOnBorrow(true).testOnReturn(true).testWhileIdle(false).minEvictableIdleTime(12000L).timeBetweenEvictionRuns(15000L).connectionTimeout(100).consistentHashImpl(2, SomeCustomConsistentHashV2.class).socketTimeout(100).tcpNoDelay(false).keySizeEstimate(128).valueSizeEstimate(1024).maxRetries(0).tcpKeepAlive(true).transportFactory(SomeTransportfactory.class).security().ssl().enable().keyStoreFileName("my-key-store.file").keyStorePassword("my-key-store.password".toCharArray()).keyStoreCertificatePassword("my-key-store-certificate.password".toCharArray()).trustStoreFileName("my-trust-store.file").trustStorePassword("my-trust-store.password".toCharArray()).protocol("TLSv1.1").security().authentication().enable().saslMechanism("my-sasl-mechanism").callbackHandler(this.callbackHandler).serverName("my-server-name").clientSubject(this.clientSubject).saslProperties(saslProperties);
        Configuration configuration = builder.build();
        this.validateConfiguration(configuration);
        ConfigurationBuilder newBuilder = new ConfigurationBuilder();
        newBuilder.read(configuration);
        Configuration newConfiguration = newBuilder.build();
        this.validateConfiguration(newConfiguration);
    }

    public void testWithProperties() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        Properties p = new Properties();
        p.setProperty("infinispan.client.hotrod.server_list", "host1:11222; host2:11222");
        p.setProperty("infinispan.client.hotrod.async_executor_factory", "org.infinispan.client.hotrod.SomeAsyncExecutorFactory");
        p.setProperty("infinispan.client.hotrod.request_balancing_strategy", "org.infinispan.client.hotrod.SomeRequestBalancingStrategy");
        p.setProperty("infinispan.client.hotrod.transport_factory", "org.infinispan.client.hotrod.SomeTransportfactory");
        p.setProperty("infinispan.client.hotrod.hash_function_impl.2", "org.infinispan.client.hotrod.SomeCustomConsistentHashV2");
        p.setProperty("maxActive", "100");
        p.setProperty("maxTotal", "150");
        p.setProperty("maxWait", "1000");
        p.setProperty("maxIdle", "20");
        p.setProperty("minIdle", "10");
        p.setProperty("exhaustedAction", "1");
        p.setProperty("numTestsPerEvictionRun", "5");
        p.setProperty("timeBetweenEvictionRunsMillis", "15000");
        p.setProperty("minEvictableIdleTimeMillis", "12000");
        p.setProperty("testOnBorrow", "true");
        p.setProperty("testOnReturn", "true");
        p.setProperty("testWhileIdle", "false");
        p.setProperty("infinispan.client.hotrod.connect_timeout", "100");
        p.setProperty("infinispan.client.hotrod.socket_timeout", "100");
        p.setProperty("infinispan.client.hotrod.tcp_no_delay", "false");
        p.setProperty("infinispan.client.hotrod.tcp_keep_alive", "true");
        p.setProperty("infinispan.client.hotrod.key_size_estimate", "128");
        p.setProperty("infinispan.client.hotrod.value_size_estimate", "1024");
        p.setProperty("infinispan.client.hotrod.max_retries", "0");
        p.setProperty("infinispan.client.hotrod.use_ssl", "true");
        p.setProperty("infinispan.client.hotrod.key_store_file_name", "my-key-store.file");
        p.setProperty("infinispan.client.hotrod.key_store_password", "my-key-store.password");
        p.setProperty("infinispan.client.hotrod.key_store_certificate_password", "my-key-store-certificate.password");
        p.setProperty("infinispan.client.hotrod.trust_store_file_name", "my-trust-store.file");
        p.setProperty("infinispan.client.hotrod.trust_store_password", "my-trust-store.password");
        p.setProperty("infinispan.client.hotrod.ssl_protocol", "TLSv1.1");
        p.setProperty("infinispan.client.hotrod.use_auth", "true");
        p.setProperty("infinispan.client.hotrod.sasl_mechanism", "my-sasl-mechanism");
        p.put("infinispan.client.hotrod.auth_callback_handler", this.callbackHandler);
        p.setProperty("infinispan.client.hotrod.auth_server_name", "my-server-name");
        p.put("infinispan.client.hotrod.auth_client_subject", this.clientSubject);
        p.setProperty("infinispan.client.hotrod.sasl_properties.A", "1");
        p.setProperty("infinispan.client.hotrod.sasl_properties.B", "2");
        p.setProperty("infinispan.client.hotrod.sasl_properties.C", "3");
        Configuration configuration = builder.withProperties(p).build();
        this.validateConfiguration(configuration);
        ConfigurationBuilder newBuilder = new ConfigurationBuilder();
        newBuilder.read(configuration);
        Configuration newConfiguration = newBuilder.build();
        this.validateConfiguration(newConfiguration);
    }

    public void testSSLContext() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.security().ssl().enable().sslContext(this.getSSLContext());
        Configuration configuration = builder.build();
        this.validateSSLContextConfiguration(configuration);
        ConfigurationBuilder newBuilder = new ConfigurationBuilder();
        newBuilder.read(configuration);
        Configuration newConfiguration = newBuilder.build();
        this.validateSSLContextConfiguration(newConfiguration);
    }

    public void testSni() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.security().ssl().enable().sslContext(this.getSSLContext()).sniHostName("sni");
        Configuration configuration = builder.build();
        this.validateSniContextConfiguration(configuration);
        ConfigurationBuilder newBuilder = new ConfigurationBuilder();
        newBuilder.read(configuration);
        Configuration newConfiguration = newBuilder.build();
        this.validateSniContextConfiguration(newConfiguration);
    }

    public void testWithPropertiesSSLContext() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        Properties p = new Properties();
        p.put("infinispan.client.hotrod.ssl_context", this.getSSLContext());
        Configuration configuration = builder.withProperties(p).build();
        this.validateSSLContextConfiguration(configuration);
        ConfigurationBuilder newBuilder = new ConfigurationBuilder();
        newBuilder.read(configuration);
        Configuration newConfiguration = newBuilder.build();
        this.validateSSLContextConfiguration(newConfiguration);
    }

    public void testWithPropertiesSni() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        Properties p = new Properties();
        p.put("infinispan.client.hotrod.sni_host_name", "sni");
        Configuration configuration = builder.withProperties(p).build();
        this.validateSniContextConfiguration(configuration);
        ConfigurationBuilder newBuilder = new ConfigurationBuilder();
        newBuilder.read(configuration);
        Configuration newConfiguration = newBuilder.build();
        this.validateSniContextConfiguration(newConfiguration);
    }

    public void testWithPropertiesAuthCallbackHandlerFQN() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        Properties p = new Properties();
        p.setProperty("infinispan.client.hotrod.auth_callback_handler", MyCallbackHandler.class.getName());
        Configuration configuration = builder.withProperties(p).build();
        AssertJUnit.assertTrue((boolean)(OPTIONS.get("infinispan.client.hotrod.auth_callback_handler").apply(configuration) instanceof MyCallbackHandler));
    }

    public void testParseServerAddresses() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.addServers("1.1.1.1:9999");
        builder.addServers("2.2.2.2");
        builder.addServers("[fe80::290:bff:fe1b:5762]:7777");
        builder.addServers("[ff01::1]");
        builder.addServers("localhost");
        builder.addServers("localhost:8382");
        Configuration cfg = builder.build();
        this.assertServer("1.1.1.1", 9999, (ServerConfiguration)cfg.servers().get(0));
        this.assertServer("2.2.2.2", 11222, (ServerConfiguration)cfg.servers().get(1));
        this.assertServer("fe80::290:bff:fe1b:5762", 7777, (ServerConfiguration)cfg.servers().get(2));
        this.assertServer("ff01::1", 11222, (ServerConfiguration)cfg.servers().get(3));
        this.assertServer("localhost", 11222, (ServerConfiguration)cfg.servers().get(4));
        this.assertServer("localhost", 8382, (ServerConfiguration)cfg.servers().get(5));
    }

    public void testPropertyReplacement() throws IOException, UnsupportedCallbackException {
        System.setProperty("test.property.server_list", "myhost:12345");
        System.setProperty("test.property.marshaller", "org.infinispan.client.hotrod.marshall.ProtoStreamMarshaller");
        System.setProperty("test.property.tcp_no_delay", "false");
        System.setProperty("test.property.tcp_keep_alive", "true");
        System.setProperty("test.property.key_size_estimate", "128");
        System.setProperty("test.property.value_size_estimate", "256");
        System.setProperty("test.property.maxTotal", "79");
        System.setProperty("test.property.maxActive", "78");
        System.setProperty("test.property.maxIdle", "77");
        System.setProperty("test.property.minIdle", "76");
        System.setProperty("test.property.timeBetweenEvictionRunsMillis", "1000");
        System.setProperty("test.property.minEvictableIdleTimeMillis", "2000");
        System.setProperty("test.property.testWhileIdle", "true");
        System.setProperty("test.property.use_auth", "true");
        System.setProperty("test.property.auth_username", "testuser");
        System.setProperty("test.property.auth_password", "testpassword");
        System.setProperty("test.property.auth_realm", "testrealm");
        System.setProperty("test.property.sasl_mechanism", "PLAIN");
        ConfigurationBuilder builder = new ConfigurationBuilder();
        Properties p = new Properties();
        InputStream inputStream = FileLookupFactory.newInstance().lookupFile("hotrod-client-replacement.properties", this.getClass().getClassLoader());
        p.load(inputStream);
        builder.withProperties(p);
        Configuration cfg = builder.build();
        this.assertServer("myhost", 12345, (ServerConfiguration)cfg.servers().get(0));
        AssertJUnit.assertEquals(ProtoStreamMarshaller.class, (Object)cfg.marshallerClass());
        AssertJUnit.assertFalse((boolean)cfg.tcpNoDelay());
        AssertJUnit.assertTrue((boolean)cfg.tcpKeepAlive());
        AssertJUnit.assertEquals((int)128, (int)cfg.keySizeEstimate());
        AssertJUnit.assertEquals((int)256, (int)cfg.valueSizeEstimate());
        AssertJUnit.assertEquals((int)79, (int)cfg.connectionPool().maxTotal());
        AssertJUnit.assertEquals((int)78, (int)cfg.connectionPool().maxActive());
        AssertJUnit.assertEquals((int)77, (int)cfg.connectionPool().maxIdle());
        AssertJUnit.assertEquals((int)76, (int)cfg.connectionPool().minIdle());
        AssertJUnit.assertEquals((long)1000L, (long)cfg.connectionPool().timeBetweenEvictionRuns());
        AssertJUnit.assertEquals((long)2000L, (long)cfg.connectionPool().minEvictableIdleTime());
        AssertJUnit.assertTrue((boolean)cfg.connectionPool().testWhileIdle());
        AssertJUnit.assertTrue((boolean)cfg.security().authentication().enabled());
        AssertJUnit.assertEquals((String)"PLAIN", (String)cfg.security().authentication().saslMechanism());
        CallbackHandler callbackHandler = cfg.security().authentication().callbackHandler();
        AssertJUnit.assertEquals(BasicCallbackHandler.class, callbackHandler.getClass());
        NameCallback nameCallback = new NameCallback("name");
        callbackHandler.handle(new Callback[]{nameCallback});
        AssertJUnit.assertEquals((String)"testuser", (String)nameCallback.getName());
    }

    @Test(expectedExceptions={CacheConfigurationException.class}, expectedExceptionsMessageRegExp="ISPN(\\d)*: Invalid max_retries \\(value=-1\\). Value should be greater or equal than zero.")
    public void testNegativeRetriesPerServer() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.maxRetries(-1);
        builder.build();
    }

    @Test(expectedExceptions={CacheConfigurationException.class})
    public void testMissingClusterNameDefinition() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.addCluster(null);
        builder.build();
    }

    @Test(expectedExceptions={CacheConfigurationException.class})
    public void testMissingHostDefinition() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.addCluster("test").addClusterNode(null, 1234);
        builder.build();
    }

    @Test(expectedExceptions={CacheConfigurationException.class})
    public void testMissingClusterServersDefinition() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.addCluster("test");
        builder.build();
    }

    @Test(expectedExceptions={CacheConfigurationException.class})
    public void testDuplicateClusterDefinition() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.addCluster("test").addClusterNode("host1", 1234);
        builder.addCluster("test").addClusterNode("host1", 5678);
        builder.build();
    }

    @Test(expectedExceptions={CacheConfigurationException.class})
    public void testInvalidAuthenticationConfig() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.security().authentication().enable().saslMechanism("PLAIN");
        builder.build();
    }

    public void testValidAuthenticationSubjectNoCBH() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.security().authentication().enable().saslMechanism("PLAIN").clientSubject(new Subject());
        builder.build();
    }

    public void testValidAuthenticationCBHNoSubject() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.security().authentication().enable().saslMechanism("PLAIN").callbackHandler((CallbackHandler)SaslTransportObjectFactory.NoOpCallbackHandler.INSTANCE);
        builder.build();
    }

    public void testClusters() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.addServers("1.1.1.1:9999");
        builder.addCluster("my-cluster").addClusterNode("localhost", 8382);
        Configuration cfg = builder.build();
        AssertJUnit.assertEquals((int)1, (int)cfg.servers().size());
        this.assertServer("1.1.1.1", 9999, (ServerConfiguration)cfg.servers().get(0));
        AssertJUnit.assertEquals((int)1, (int)cfg.clusters().size());
        AssertJUnit.assertEquals((int)1, (int)((ClusterConfiguration)cfg.clusters().get(0)).getCluster().size());
        this.assertServer("localhost", 8382, (ServerConfiguration)((ClusterConfiguration)cfg.clusters().get(0)).getCluster().get(0));
    }

    private void assertServer(String host, int port, ServerConfiguration serverCfg) {
        AssertJUnit.assertEquals((String)host, (String)serverCfg.host());
        AssertJUnit.assertEquals((int)port, (int)serverCfg.port());
    }

    private void validateConfiguration(Configuration configuration) {
        AssertJUnit.assertEquals((int)2, (int)configuration.servers().size());
        for (int i = 0; i < configuration.servers().size(); ++i) {
            AssertJUnit.assertEquals((String)String.format("host%d", i + 1), (String)((ServerConfiguration)configuration.servers().get(i)).host());
            AssertJUnit.assertEquals((int)11222, (int)((ServerConfiguration)configuration.servers().get(i)).port());
        }
        ConfigurationTest.assertEqualsConfig(SomeAsyncExecutorFactory.class, "infinispan.client.hotrod.async_executor_factory", configuration);
        ConfigurationTest.assertEqualsConfig(SomeRequestBalancingStrategy.class, "infinispan.client.hotrod.request_balancing_strategy", configuration);
        ConfigurationTest.assertEqualsConfig(SomeTransportfactory.class, "infinispan.client.hotrod.transport_factory", configuration);
        AssertJUnit.assertEquals(null, (Object)configuration.consistentHashImpl(1));
        AssertJUnit.assertEquals(SomeCustomConsistentHashV2.class, (Object)configuration.consistentHashImpl(2));
        ConfigurationTest.assertEqualsConfig(100, "maxActive", configuration);
        ConfigurationTest.assertEqualsConfig(150, "maxTotal", configuration);
        ConfigurationTest.assertEqualsConfig(1000L, "maxWait", configuration);
        ConfigurationTest.assertEqualsConfig(20, "maxIdle", configuration);
        ConfigurationTest.assertEqualsConfig(10, "minIdle", configuration);
        ConfigurationTest.assertEqualsConfig(ExhaustedAction.WAIT, "exhaustedAction", configuration);
        ConfigurationTest.assertEqualsConfig(5, "numTestsPerEvictionRun", configuration);
        ConfigurationTest.assertEqualsConfig(15000L, "timeBetweenEvictionRunsMillis", configuration);
        ConfigurationTest.assertEqualsConfig(12000L, "minEvictableIdleTimeMillis", configuration);
        ConfigurationTest.assertEqualsConfig(true, "testOnBorrow", configuration);
        ConfigurationTest.assertEqualsConfig(true, "testOnReturn", configuration);
        ConfigurationTest.assertEqualsConfig(false, "testWhileIdle", configuration);
        ConfigurationTest.assertEqualsConfig(100, "infinispan.client.hotrod.connect_timeout", configuration);
        ConfigurationTest.assertEqualsConfig(100, "infinispan.client.hotrod.socket_timeout", configuration);
        ConfigurationTest.assertEqualsConfig(false, "infinispan.client.hotrod.tcp_no_delay", configuration);
        ConfigurationTest.assertEqualsConfig(true, "infinispan.client.hotrod.tcp_keep_alive", configuration);
        ConfigurationTest.assertEqualsConfig(128, "infinispan.client.hotrod.key_size_estimate", configuration);
        ConfigurationTest.assertEqualsConfig(1024, "infinispan.client.hotrod.value_size_estimate", configuration);
        ConfigurationTest.assertEqualsConfig(0, "infinispan.client.hotrod.max_retries", configuration);
        ConfigurationTest.assertEqualsConfig(true, "infinispan.client.hotrod.use_ssl", configuration);
        ConfigurationTest.assertEqualsConfig("my-key-store.file", "infinispan.client.hotrod.key_store_file_name", configuration);
        ConfigurationTest.assertEqualsConfig("my-key-store.password", "infinispan.client.hotrod.key_store_password", configuration);
        ConfigurationTest.assertEqualsConfig("my-key-store-certificate.password", "infinispan.client.hotrod.key_store_certificate_password", configuration);
        ConfigurationTest.assertEqualsConfig("my-trust-store.file", "infinispan.client.hotrod.trust_store_file_name", configuration);
        ConfigurationTest.assertEqualsConfig("my-trust-store.password", "infinispan.client.hotrod.trust_store_password", configuration);
        ConfigurationTest.assertEqualsConfig("TLSv1.1", "infinispan.client.hotrod.ssl_protocol", configuration);
        ConfigurationTest.assertEqualsConfig(true, "infinispan.client.hotrod.use_auth", configuration);
        ConfigurationTest.assertEqualsConfig("my-sasl-mechanism", "infinispan.client.hotrod.sasl_mechanism", configuration);
        ConfigurationTest.assertEqualsConfig(this.callbackHandler, "infinispan.client.hotrod.auth_callback_handler", configuration);
        ConfigurationTest.assertEqualsConfig("my-server-name", "infinispan.client.hotrod.auth_server_name", configuration);
        ConfigurationTest.assertEqualsConfig(this.clientSubject, "infinispan.client.hotrod.auth_client_subject", configuration);
        ConfigurationTest.assertEqualsConfig("1", "infinispan.client.hotrod.sasl_properties.A", configuration);
        ConfigurationTest.assertEqualsConfig("2", "infinispan.client.hotrod.sasl_properties.B", configuration);
        ConfigurationTest.assertEqualsConfig("3", "infinispan.client.hotrod.sasl_properties.C", configuration);
    }

    private void validateSSLContextConfiguration(Configuration configuration) {
        ConfigurationTest.assertEqualsConfig(this.getSSLContext(), "infinispan.client.hotrod.ssl_context", configuration);
    }

    private void validateSniContextConfiguration(Configuration configuration) {
        ConfigurationTest.assertEqualsConfig("sni", "infinispan.client.hotrod.sni_host_name", configuration);
    }

    private SSLContext getSSLContext() {
        try {
            return SSLContext.getDefault();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static void assertEqualsConfig(Object expected, String propertyName, Configuration cfg) {
        AssertJUnit.assertEquals((Object)expected, OPTIONS.get(propertyName).apply(cfg));
        AssertJUnit.assertEquals((Object)TYPES.get(expected.getClass()).apply(expected), (Object)cfg.properties().get(propertyName));
    }

    static {
        OPTIONS.put("infinispan.client.hotrod.async_executor_factory", c -> c.asyncExecutorFactory().factoryClass());
        OPTIONS.put("infinispan.client.hotrod.request_balancing_strategy", Configuration::balancingStrategyClass);
        OPTIONS.put("infinispan.client.hotrod.transport_factory", Configuration::transportFactory);
        OPTIONS.put("maxActive", c -> c.connectionPool().maxActive());
        OPTIONS.put("maxTotal", c -> c.connectionPool().maxTotal());
        OPTIONS.put("maxWait", c -> c.connectionPool().maxWait());
        OPTIONS.put("maxIdle", c -> c.connectionPool().maxIdle());
        OPTIONS.put("minIdle", c -> c.connectionPool().minIdle());
        OPTIONS.put("exhaustedAction", c -> c.connectionPool().exhaustedAction());
        OPTIONS.put("numTestsPerEvictionRun", c -> c.connectionPool().numTestsPerEvictionRun());
        OPTIONS.put("timeBetweenEvictionRunsMillis", c -> c.connectionPool().timeBetweenEvictionRuns());
        OPTIONS.put("minEvictableIdleTimeMillis", c -> c.connectionPool().minEvictableIdleTime());
        OPTIONS.put("testOnBorrow", c -> c.connectionPool().testOnBorrow());
        OPTIONS.put("testOnReturn", c -> c.connectionPool().testOnReturn());
        OPTIONS.put("testWhileIdle", c -> c.connectionPool().testWhileIdle());
        OPTIONS.put("infinispan.client.hotrod.connect_timeout", Configuration::connectionTimeout);
        OPTIONS.put("infinispan.client.hotrod.socket_timeout", Configuration::socketTimeout);
        OPTIONS.put("infinispan.client.hotrod.tcp_no_delay", Configuration::tcpNoDelay);
        OPTIONS.put("infinispan.client.hotrod.tcp_keep_alive", Configuration::tcpKeepAlive);
        OPTIONS.put("infinispan.client.hotrod.key_size_estimate", Configuration::keySizeEstimate);
        OPTIONS.put("infinispan.client.hotrod.value_size_estimate", Configuration::valueSizeEstimate);
        OPTIONS.put("infinispan.client.hotrod.max_retries", Configuration::maxRetries);
        OPTIONS.put("infinispan.client.hotrod.use_ssl", c -> c.security().ssl().enabled());
        OPTIONS.put("infinispan.client.hotrod.key_store_file_name", c -> c.security().ssl().keyStoreFileName());
        OPTIONS.put("infinispan.client.hotrod.sni_host_name", c -> c.security().ssl().sniHostName());
        OPTIONS.put("infinispan.client.hotrod.key_store_password", c -> new String(c.security().ssl().keyStorePassword()));
        OPTIONS.put("infinispan.client.hotrod.key_store_certificate_password", c -> new String(c.security().ssl().keyStoreCertificatePassword()));
        OPTIONS.put("infinispan.client.hotrod.trust_store_file_name", c -> c.security().ssl().trustStoreFileName());
        OPTIONS.put("infinispan.client.hotrod.trust_store_password", c -> new String(c.security().ssl().trustStorePassword()));
        OPTIONS.put("infinispan.client.hotrod.ssl_protocol", c -> c.security().ssl().protocol());
        OPTIONS.put("infinispan.client.hotrod.ssl_context", c -> c.security().ssl().sslContext());
        OPTIONS.put("infinispan.client.hotrod.use_auth", c -> c.security().authentication().enabled());
        OPTIONS.put("infinispan.client.hotrod.sasl_mechanism", c -> c.security().authentication().saslMechanism());
        OPTIONS.put("infinispan.client.hotrod.auth_callback_handler", c -> c.security().authentication().callbackHandler());
        OPTIONS.put("infinispan.client.hotrod.auth_server_name", c -> c.security().authentication().serverName());
        OPTIONS.put("infinispan.client.hotrod.auth_client_subject", c -> c.security().authentication().clientSubject());
        OPTIONS.put("infinispan.client.hotrod.sasl_properties.A", c -> (String)c.security().authentication().saslProperties().get("A"));
        OPTIONS.put("infinispan.client.hotrod.sasl_properties.B", c -> (String)c.security().authentication().saslProperties().get("B"));
        OPTIONS.put("infinispan.client.hotrod.sasl_properties.C", c -> (String)c.security().authentication().saslProperties().get("C"));
        TYPES.put(Boolean.class, b -> Boolean.toString((Boolean)b));
        TYPES.put(ExhaustedAction.class, e -> Integer.toString(((ExhaustedAction)e).ordinal()));
        TYPES.put(Class.class, c -> ((Class)c).getName());
        TYPES.put(Integer.class, Object::toString);
        TYPES.put(Long.class, Object::toString);
        TYPES.put(String.class, s -> s);
        TYPES.put(SSLContext.class, s -> s);
        TYPES.put(MyCallbackHandler.class, c -> c);
        TYPES.put(Subject.class, s -> s);
    }

    public static class MyCallbackHandler
    implements CallbackHandler {
        @Override
        public void handle(Callback[] callbacks) {
        }
    }
}

