/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.event;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Set;
import org.infinispan.client.hotrod.impl.transport.tcp.FailoverRequestBalancingStrategy;
import org.infinispan.client.hotrod.impl.transport.tcp.RoundRobinBalancingStrategy;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class StickyServerLoadBalancingStrategy
implements FailoverRequestBalancingStrategy {
    static Log log = LogFactory.getLog(StickyServerLoadBalancingStrategy.class);
    private InetSocketAddress stickyServer;
    private final RoundRobinBalancingStrategy delegate = new RoundRobinBalancingStrategy();

    public void setServers(Collection<SocketAddress> servers) {
        log.info((Object)("Set servers: " + servers));
        this.delegate.setServers(servers);
        this.stickyServer = (InetSocketAddress)servers.iterator().next();
    }

    public SocketAddress nextServer(Set<SocketAddress> failedServers) {
        if (failedServers != null && !failedServers.isEmpty()) {
            return this.delegate.nextServer(failedServers);
        }
        log.info((Object)("Select " + this.stickyServer + " for load balancing"));
        return this.stickyServer;
    }
}

