/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.query;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.Search;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.marshall.ProtoStreamMarshaller;
import org.infinispan.client.hotrod.query.testdomain.protobuf.AddressPB;
import org.infinispan.client.hotrod.query.testdomain.protobuf.UserPB;
import org.infinispan.client.hotrod.query.testdomain.protobuf.marshallers.MarshallerRegistration;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Index;
import org.infinispan.query.dsl.Expression;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.embedded.testdomain.Address;
import org.infinispan.query.dsl.embedded.testdomain.User;
import org.infinispan.query.remote.ProtobufMetadataManager;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.query.MultiHotRodServerQueryTest", groups={"functional"})
public class MultiHotRodServerQueryTest
extends MultiHotRodServersTest {
    protected RemoteCache<Integer, User> remoteCache0;
    protected RemoteCache<Integer, User> remoteCache1;

    protected void createCacheManagers() throws Throwable {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = HotRodTestingUtil.hotRodCacheConfiguration((org.infinispan.configuration.cache.ConfigurationBuilder)MultiHotRodServerQueryTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC, (boolean)false));
        builder.indexing().index(Index.ALL).addProperty("default.directory_provider", "ram").addProperty("lucene_version", "LUCENE_CURRENT");
        this.createHotRodServers(3, builder);
        this.waitForClusterToForm();
        this.remoteCache0 = this.client(0).getCache();
        this.remoteCache1 = this.client(1).getCache();
    }

    @Override
    protected ConfigurationBuilder createHotRodClientConfigurationBuilder(int serverPort) {
        return super.createHotRodClientConfigurationBuilder(serverPort).marshaller((Marshaller)new ProtoStreamMarshaller());
    }

    @BeforeClass(alwaysRun=true)
    protected void populateCache() throws Exception {
        ProtobufMetadataManager protobufMetadataManager = (ProtobufMetadataManager)this.manager(0).getGlobalComponentRegistry().getComponent(ProtobufMetadataManager.class);
        protobufMetadataManager.registerProtofile("sample_bank_account/bank.proto", this.read("/sample_bank_account/bank.proto"));
        AssertJUnit.assertNull((Object)protobufMetadataManager.getFileErrors("sample_bank_account/bank.proto"));
        AssertJUnit.assertNull((Object)protobufMetadataManager.getFilesWithErrors());
        for (RemoteCacheManager rcm : this.clients) {
            MarshallerRegistration.registerMarshallers(ProtoStreamMarshaller.getSerializationContext((RemoteCacheManager)rcm));
        }
        UserPB user1 = new UserPB();
        user1.setId(1);
        user1.setName("Tom");
        user1.setSurname("Cat");
        user1.setGender(User.Gender.MALE);
        user1.setAge(5);
        user1.setAccountIds(Collections.singleton(12));
        AddressPB address1 = new AddressPB();
        address1.setStreet("Dark Alley");
        address1.setPostCode("1234");
        user1.setAddresses(Collections.singletonList(address1));
        this.remoteCache0.put((Object)1, (Object)user1);
        AssertJUnit.assertNotNull((Object)this.remoteCache0.get((Object)1));
        AssertJUnit.assertNotNull((Object)this.remoteCache1.get((Object)1));
        UserPB user2 = new UserPB();
        user2.setId(2);
        user2.setName("Adrian");
        user2.setSurname("Nistor");
        user2.setGender(User.Gender.MALE);
        user2.setAge(22);
        AddressPB address2 = new AddressPB();
        address2.setStreet("Old Street");
        address2.setPostCode("XYZ");
        user2.setAddresses(Collections.singletonList(address2));
        this.remoteCache1.put((Object)2, (Object)user2);
        AssertJUnit.assertNotNull((Object)this.remoteCache0.get((Object)2));
        AssertJUnit.assertNotNull((Object)this.remoteCache1.get((Object)2));
        this.client(0).getCache().put((Object)"dummy", (Object)"a primitive value cannot be queried");
    }

    private String read(String classPathResource) throws IOException {
        return Util.read((InputStream)((Object)((Object)this)).getClass().getResourceAsStream(classPathResource));
    }

    public void testAttributeQuery() throws Exception {
        User fromCache = (User)this.remoteCache0.get((Object)1);
        AssertJUnit.assertNotNull((Object)fromCache);
        this.assertUser1(fromCache);
        QueryFactory qf = Search.getQueryFactory(this.remoteCache1);
        Query query = qf.from(UserPB.class).having("name").eq((Object)"Tom").build();
        List list = query.list();
        AssertJUnit.assertNotNull((Object)list);
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals(UserPB.class, ((User)list.get(0)).getClass());
        this.assertUser1((User)list.get(0));
    }

    public void testGroupByQuery() throws Exception {
        User fromCache = (User)this.remoteCache0.get((Object)1);
        AssertJUnit.assertNotNull((Object)fromCache);
        this.assertUser1(fromCache);
        QueryFactory qf = Search.getQueryFactory(this.remoteCache0);
        Query query = qf.from(UserPB.class).select(new Expression[]{Expression.property((String)"name"), Expression.count((String)"age")}).having("age").gte((Object)5).groupBy(new String[]{"name"}).orderBy("name").build();
        List list = query.list();
        AssertJUnit.assertNotNull((Object)list);
        AssertJUnit.assertEquals((int)2, (int)list.size());
        AssertJUnit.assertEquals(Object[].class, ((Object[])list.get(0)).getClass());
        AssertJUnit.assertEquals(Object[].class, ((Object[])list.get(1)).getClass());
        AssertJUnit.assertEquals((Object)"Adrian", (Object)((Object[])list.get(0))[0]);
        AssertJUnit.assertEquals((Object)"Tom", (Object)((Object[])list.get(1))[0]);
    }

    public void testEmbeddedAttributeQuery() throws Exception {
        QueryFactory qf = Search.getQueryFactory(this.remoteCache1);
        Query query = qf.from(UserPB.class).having("addresses.postCode").eq((Object)"1234").build();
        List list = query.list();
        AssertJUnit.assertNotNull((Object)list);
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals(UserPB.class, ((User)list.get(0)).getClass());
        this.assertUser1((User)list.get(0));
    }

    @Test(expectedExceptions={HotRodClientException.class}, expectedExceptionsMessageRegExp=".*ISPN028503: Property addresses can not be selected from type sample_bank_account.User since it is an embedded entity.")
    public void testInvalidEmbeddedAttributeQuery() throws Exception {
        QueryFactory qf = Search.getQueryFactory(this.remoteCache1);
        Query q = qf.from(UserPB.class).select(new String[]{"addresses"}).build();
        q.list();
    }

    public void testProjections() throws Exception {
        User fromCache = (User)this.remoteCache0.get((Object)1);
        this.assertUser1(fromCache);
        QueryFactory qf = Search.getQueryFactory(this.remoteCache1);
        Query query = qf.from(UserPB.class).select(new String[]{"name", "surname"}).having("name").eq((Object)"Tom").build();
        List list = query.list();
        AssertJUnit.assertNotNull((Object)list);
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals(Object[].class, ((Object[])list.get(0)).getClass());
        AssertJUnit.assertEquals((Object)"Tom", (Object)((Object[])list.get(0))[0]);
        AssertJUnit.assertEquals((Object)"Cat", (Object)((Object[])list.get(0))[1]);
    }

    private void assertUser1(User user) {
        AssertJUnit.assertNotNull((Object)user);
        AssertJUnit.assertEquals((int)1, (int)user.getId());
        AssertJUnit.assertEquals((String)"Tom", (String)user.getName());
        AssertJUnit.assertEquals((String)"Cat", (String)user.getSurname());
        AssertJUnit.assertEquals((Object)User.Gender.MALE, (Object)user.getGender());
        AssertJUnit.assertNotNull((Object)user.getAccountIds());
        AssertJUnit.assertEquals((int)1, (int)user.getAccountIds().size());
        AssertJUnit.assertTrue((boolean)user.getAccountIds().contains(12));
        AssertJUnit.assertNotNull((Object)user.getAddresses());
        AssertJUnit.assertEquals((int)1, (int)user.getAddresses().size());
        AssertJUnit.assertEquals((String)"Dark Alley", (String)((Address)user.getAddresses().get(0)).getStreet());
        AssertJUnit.assertEquals((String)"1234", (String)((Address)user.getAddresses().get(0)).getPostCode());
    }
}

