/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public abstract class BaseBulkGetTest
extends MultipleCacheManagersTest {
    protected HotRodServer[] hotrodServers;
    protected RemoteCacheManager remoteCacheManager;
    protected RemoteCache<Object, Object> remoteCache;

    protected abstract int numberOfHotRodServers();

    protected abstract org.infinispan.configuration.cache.ConfigurationBuilder clusterConfig();

    protected void createCacheManagers() throws Throwable {
        int numServers = this.numberOfHotRodServers();
        this.hotrodServers = new HotRodServer[numServers];
        this.createCluster(HotRodTestingUtil.hotRodCacheConfiguration((org.infinispan.configuration.cache.ConfigurationBuilder)this.clusterConfig()), this.numberOfHotRodServers());
        for (int i = 0; i < numServers; ++i) {
            EmbeddedCacheManager cm = (EmbeddedCacheManager)this.cacheManagers.get(i);
            this.hotrodServers[i] = HotRodClientTestingUtil.startHotRodServer(cm);
        }
        String servers = HotRodClientTestingUtil.getServersString(this.hotrodServers);
        ConfigurationBuilder clientBuilder = new ConfigurationBuilder();
        clientBuilder.addServers(servers);
        this.remoteCacheManager = new RemoteCacheManager(clientBuilder.build());
        this.remoteCache = this.remoteCacheManager.getCache();
    }

    @AfterClass
    public void release() {
        HotRodClientTestingUtil.killRemoteCacheManager(this.remoteCacheManager);
        HotRodClientTestingUtil.killServers(this.hotrodServers);
    }

    private void populateCacheManager() {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        for (int i = 0; i < 100; ++i) {
            map.put(i, i);
        }
        this.remoteCache.putAll(map);
    }

    public void testBulkGet() {
        this.populateCacheManager();
        Map map = this.remoteCache.getBulk();
        assert (map.size() == 100);
        for (int i = 0; i < 100; ++i) {
            assert (map.get(i).equals(i));
        }
        assert (map.size() == 100);
    }

    public void testBulkGetWithSize() {
        this.populateCacheManager();
        Map map = this.remoteCache.getBulk(50);
        AssertJUnit.assertEquals((int)50, (int)map.size());
        for (int i = 0; i < 100; ++i) {
            if (!map.containsKey(i)) continue;
            Integer value = (Integer)map.get(i);
            AssertJUnit.assertEquals((Object)i, (Object)value);
        }
    }

    public void testBulkGetAfterLifespanExpire() throws InterruptedException {
        HashMap<String, String> dataIn = new HashMap<String, String>();
        dataIn.put("aKey", "aValue");
        dataIn.put("bKey", "bValue");
        long startTime = System.currentTimeMillis();
        long lifespan = 10000L;
        this.remoteCache.putAll(dataIn, 10000L, TimeUnit.MILLISECONDS);
        Map dataOut = new HashMap();
        while (true) {
            dataOut = this.remoteCache.getBulk();
            if (System.currentTimeMillis() >= startTime + 10000L) break;
            AssertJUnit.assertEquals(dataIn, dataOut);
            Thread.sleep(100L);
        }
        while (System.currentTimeMillis() < startTime + 10000L + 30000L) {
            dataOut = this.remoteCache.getBulk();
            if (dataOut.size() != 0) continue;
            return;
        }
        assert (dataOut.size() == 0) : String.format("Data not empty, it contains: %s elements", dataOut.size());
    }
}

