/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.io.IOException;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.PrincipalRoleMapper;
import org.infinispan.security.Security;
import org.infinispan.security.impl.CommonNameRoleMapper;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.core.security.ServerAuthenticationProvider;
import org.infinispan.server.core.security.simple.SimpleServerAuthenticationProvider;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.SslAuthenticationTest", groups={"functional"})
public class SslAuthenticationTest
extends SingleCacheManagerTest {
    private static final Log log = LogFactory.getLog(SslAuthenticationTest.class);
    static final Subject ADMIN = TestingUtil.makeSubject((String[])new String[]{"CN=admin"});
    public static final String UNAUTHORIZED = "unauthorized";
    private RemoteCacheManager remoteCacheManager;
    protected HotRodServer hotrodServer;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        GlobalConfigurationBuilder global = new GlobalConfigurationBuilder();
        global.security().authorization().enable().principalRoleMapper((PrincipalRoleMapper)new CommonNameRoleMapper()).role("admin").permission(AuthorizationPermission.ALL).role("HotRod").permission(AuthorizationPermission.READ).permission(AuthorizationPermission.WRITE).role("RodHot").permission(AuthorizationPermission.READ).permission(AuthorizationPermission.WRITE);
        org.infinispan.configuration.cache.ConfigurationBuilder builder = HotRodTestingUtil.hotRodCacheConfiguration();
        builder.security().authorization().enable().role("HotRod").role("admin");
        this.cacheManager = TestCacheManagerFactory.createCacheManager((GlobalConfigurationBuilder)global, (org.infinispan.configuration.cache.ConfigurationBuilder)builder);
        this.cacheManager.getCache();
        org.infinispan.configuration.cache.ConfigurationBuilder unauthorizedBuilder = HotRodTestingUtil.hotRodCacheConfiguration();
        unauthorizedBuilder.security().authorization().enable().role("RodHot").role("admin");
        this.cacheManager.defineConfiguration(UNAUTHORIZED, unauthorizedBuilder.build());
        this.cacheManager.getCache(UNAUTHORIZED);
        return this.cacheManager;
    }

    protected void setup() throws Exception {
        Security.doAs((Subject)ADMIN, (PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Void run() throws Exception {
                SslAuthenticationTest.this.cacheManager = SslAuthenticationTest.this.createCacheManager();
                if (SslAuthenticationTest.this.cache == null) {
                    SslAuthenticationTest.this.cache = SslAuthenticationTest.this.cacheManager.getCache();
                }
                return null;
            }
        });
        this.hotrodServer = new HotRodServer();
        final HotRodServerConfigurationBuilder serverBuilder = HotRodTestingUtil.getDefaultHotRodConfiguration();
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        String keyStoreFileName = tccl.getResource("keystore.jks").getPath();
        String trustStoreFileName = tccl.getResource("truststore.jks").getPath();
        SimpleServerAuthenticationProvider sap = new SimpleServerAuthenticationProvider();
        serverBuilder.ssl().enable().requireClientAuth(true).keyStoreFileName(keyStoreFileName).keyStorePassword("secret".toCharArray()).trustStoreFileName(trustStoreFileName).trustStorePassword("secret".toCharArray());
        serverBuilder.authentication().enable().serverName("localhost").addAllowedMech("EXTERNAL").serverAuthenticationProvider((ServerAuthenticationProvider)sap);
        Security.doAs((Subject)ADMIN, (PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Void run() throws Exception {
                SslAuthenticationTest.this.hotrodServer.start((ProtocolServerConfiguration)serverBuilder.build(), SslAuthenticationTest.this.cacheManager);
                return null;
            }
        });
        log.info((Object)("Started server on port: " + this.hotrodServer.getPort()));
        ConfigurationBuilder clientBuilder = new ConfigurationBuilder();
        clientBuilder.addServer().host("127.0.0.1").port(this.hotrodServer.getPort()).socketTimeout(3000).connectionPool().maxActive(1).security().authentication().enable().saslMechanism("EXTERNAL").callbackHandler(new CallbackHandler(){

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            }
        }).ssl().enable().keyStoreFileName(keyStoreFileName).keyStorePassword("secret".toCharArray()).trustStoreFileName(trustStoreFileName).trustStorePassword("secret".toCharArray()).connectionPool().timeBetweenEvictionRuns(2000L);
        this.remoteCacheManager = new RemoteCacheManager(clientBuilder.build());
    }

    protected void teardown() {
        HotRodClientTestingUtil.killRemoteCacheManager(this.remoteCacheManager);
        HotRodClientTestingUtil.killServers(this.hotrodServer);
        super.teardown();
    }

    protected void clearContent() {
        Security.doAs((Subject)ADMIN, (PrivilegedAction)new PrivilegedAction<Object>(){

            @Override
            public Void run() {
                SslAuthenticationTest.this.cacheManager.getCache().clear();
                return null;
            }
        });
    }

    public void testSSLAuthentication() throws Exception {
        RemoteCache cache = this.remoteCacheManager.getCache();
        cache.put((Object)"k", (Object)"v");
        AssertJUnit.assertEquals((String)"v", (String)((String)cache.get((Object)"k")));
    }

    @Test(expectedExceptions={HotRodClientException.class}, expectedExceptionsMessageRegExp=".*ISPN000287.*")
    public void testSSLUnauthorized() throws Exception {
        RemoteCache cache = this.remoteCacheManager.getCache(UNAUTHORIZED);
        cache.put((Object)"k1", (Object)"v1");
        AssertJUnit.assertEquals((String)"v1", (String)((String)cache.get((Object)"k1")));
    }
}

