/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.xsite;

import java.util.Optional;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.xsite.AbstractHotRodSiteFailoverTest;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.xsite.SiteManualSwitchTest")
public class SiteManualSwitchTest
extends AbstractHotRodSiteFailoverTest {
    @Override
    protected void createSites() {
        super.createSites();
        this.addHitCountInterceptors();
    }

    public void testManualClusterSwitch() {
        RemoteCacheManager clientA = this.client(SITE_A, Optional.of(SITE_B));
        RemoteCacheManager clientB = this.client(SITE_B, Optional.empty());
        RemoteCache cacheA = clientA.getCache();
        RemoteCache cacheB = clientB.getCache();
        this.assertNoHits();
        this.assertSingleSiteHit(SITE_A, SITE_B, () -> AssertJUnit.assertNull((Object)cacheA.put((Object)1, (Object)"v1")));
        this.assertSingleSiteHit(SITE_A, SITE_B, () -> AssertJUnit.assertEquals((String)"v1", (String)((String)cacheA.get((Object)1))));
        this.assertSingleSiteHit(SITE_B, SITE_A, () -> AssertJUnit.assertNull((Object)cacheB.put((Object)2, (Object)"v2")));
        this.assertSingleSiteHit(SITE_B, SITE_A, () -> AssertJUnit.assertEquals((String)"v2", (String)((String)cacheB.get((Object)2))));
        AssertJUnit.assertTrue((boolean)clientA.switchToCluster(SITE_B));
        this.assertSingleSiteHit(SITE_B, SITE_A, () -> AssertJUnit.assertNull((Object)cacheA.put((Object)3, (Object)"v3")));
        this.assertSingleSiteHit(SITE_B, SITE_A, () -> AssertJUnit.assertEquals((String)"v3", (String)((String)cacheA.get((Object)3))));
        AssertJUnit.assertTrue((boolean)clientA.switchToDefaultCluster());
        this.assertSingleSiteHit(SITE_A, SITE_B, () -> AssertJUnit.assertNull((Object)cacheA.put((Object)4, (Object)"v4")));
        this.assertSingleSiteHit(SITE_A, SITE_B, () -> AssertJUnit.assertEquals((String)"v4", (String)((String)cacheA.get((Object)4))));
    }

    private void assertSingleSiteHit(String siteHit, String siteNotHit, Runnable r) {
        r.run();
        this.assertSiteHit(siteHit, 1);
        this.assertSiteNotHit(siteNotHit);
    }
}

