/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.client.hotrod.configuration.ClientIntelligence;
import org.infinispan.client.hotrod.impl.MetadataValueImpl;
import org.infinispan.client.hotrod.impl.iteration.KeyTracker;
import org.infinispan.client.hotrod.impl.operations.HotRodOperation;
import org.infinispan.client.hotrod.impl.operations.IterationNextResponse;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HeaderParams;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.impl.transport.Transport;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.client.hotrod.marshall.MarshallerUtil;
import org.infinispan.commons.marshall.Marshaller;

public class IterationNextOperation<E>
extends HotRodOperation {
    private static final Log log = LogFactory.getLog(IterationNextOperation.class);
    private final String iterationId;
    private final Transport transport;
    private final KeyTracker segmentKeyTracker;

    protected IterationNextOperation(Codec codec, int flags, ClientIntelligence clientIntelligence, byte[] cacheName, AtomicInteger topologyId, String iterationId, Transport transport, KeyTracker segmentKeyTracker) {
        super(codec, flags, clientIntelligence, cacheName, topologyId);
        this.iterationId = iterationId;
        this.transport = transport;
        this.segmentKeyTracker = segmentKeyTracker;
    }

    @Override
    public IterationNextResponse<E> execute() {
        HeaderParams params = this.writeHeader(this.transport, (short)51);
        this.transport.writeString(this.iterationId);
        this.transport.flush();
        short status = this.readHeaderAndValidate(this.transport, params);
        byte[] finishedSegments = this.transport.readArray();
        int entriesSize = this.transport.readVInt();
        ArrayList<Map.Entry<Object, AbstractMap.SimpleEntry<Object, Object[]>>> entries = new ArrayList<Map.Entry<Object, AbstractMap.SimpleEntry<Object, Object[]>>>(entriesSize);
        if (entriesSize > 0) {
            int projectionsSize = this.transport.readVInt();
            for (int i = 0; i < entriesSize; ++i) {
                Object value;
                short meta = this.transport.readByte();
                long creation = -1L;
                int lifespan = -1;
                long lastUsed = -1L;
                int maxIdle = -1;
                long version = 0L;
                if (meta == 1) {
                    short flags = this.transport.readByte();
                    if ((flags & 1) != 1) {
                        creation = this.transport.readLong();
                        lifespan = this.transport.readVInt();
                    }
                    if ((flags & 2) != 2) {
                        lastUsed = this.transport.readLong();
                        maxIdle = this.transport.readVInt();
                    }
                    version = this.transport.readLong();
                }
                byte[] key = this.transport.readArray();
                if (projectionsSize > 1) {
                    Object[] projections = new Object[projectionsSize];
                    for (int j = 0; j < projectionsSize; ++j) {
                        projections[j] = this.unmarshall(this.transport.readArray(), status);
                    }
                    value = projections;
                } else {
                    value = this.unmarshall(this.transport.readArray(), status);
                }
                if (meta == 1) {
                    value = new MetadataValueImpl<Object[]>(creation, lifespan, lastUsed, maxIdle, version, (Object[])value);
                }
                if (!this.segmentKeyTracker.track(key, status)) continue;
                entries.add(new AbstractMap.SimpleEntry<Object, Object[]>(this.unmarshall(key, status), (Object[])value));
            }
        }
        this.segmentKeyTracker.segmentsFinished(finishedSegments);
        if (HotRodConstants.isInvalidIteration(status)) {
            throw log.errorRetrievingNext(this.iterationId);
        }
        return new IterationNextResponse(status, entries, entriesSize > 0);
    }

    private Object unmarshall(byte[] bytes, short status) {
        Marshaller marshaller = this.transport.getTransportFactory().getMarshaller();
        return MarshallerUtil.bytes2obj(marshaller, bytes, status);
    }
}

