/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.BaseAsyncInterceptor;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeMethod;

public abstract class HitsAwareCacheManagersTest
extends MultipleCacheManagersTest {
    protected Map<SocketAddress, HotRodServer> addr2hrServer = new LinkedHashMap<SocketAddress, HotRodServer>();
    protected List<RemoteCacheManager> clients = new ArrayList<RemoteCacheManager>();

    protected void createHotRodServers(int num, org.infinispan.configuration.cache.ConfigurationBuilder defaultBuilder) {
        int i;
        for (i = 0; i < num; ++i) {
            this.addHotRodServer(defaultBuilder);
        }
        for (i = 0; i < num; ++i) {
            assert (this.manager(i).getCache() != null);
        }
        TestingUtil.blockUntilViewReceived((Cache)this.manager(0).getCache(), (int)num);
        for (i = 0; i < num; ++i) {
            TestingUtil.blockUntilCacheStatusAchieved((Cache)this.manager(i).getCache(), (ComponentStatus)ComponentStatus.RUNNING, (long)10000L);
        }
        this.addInterceptors();
        for (i = 0; i < num; ++i) {
            this.clients.add(this.createClient());
        }
    }

    protected RemoteCacheManager client(int i) {
        return this.clients.get(i);
    }

    protected RemoteCacheManager createClient() {
        return new RemoteCacheManager(this.createHotRodClientConfigurationBuilder(this.addr2hrServer.values().iterator().next().getPort()).build());
    }

    protected ConfigurationBuilder createHotRodClientConfigurationBuilder(int serverPort) {
        ConfigurationBuilder clientBuilder = new ConfigurationBuilder();
        clientBuilder.addServer().host("localhost").port(serverPort);
        return clientBuilder;
    }

    protected HotRodServer addHotRodServer(org.infinispan.configuration.cache.ConfigurationBuilder builder) {
        EmbeddedCacheManager cm = this.addClusterEnabledCacheManager(builder);
        HotRodServer server = HotRodClientTestingUtil.startHotRodServer(cm);
        InetSocketAddress addr = new InetSocketAddress(server.getHost(), server.getPort());
        this.addr2hrServer.put(addr, server);
        return server;
    }

    protected HotRodServer addHotRodServer(org.infinispan.configuration.cache.ConfigurationBuilder builder, int port) {
        EmbeddedCacheManager cm = this.addClusterEnabledCacheManager(builder);
        HotRodServer server = HotRodTestingUtil.startHotRodServer((EmbeddedCacheManager)cm, (int)port, (HotRodServerConfigurationBuilder)new HotRodServerConfigurationBuilder());
        InetSocketAddress addr = new InetSocketAddress(server.getHost(), server.getPort());
        this.addr2hrServer.put(addr, server);
        return server;
    }

    protected void killServer() {
        Iterator<HotRodServer> it = this.addr2hrServer.values().iterator();
        HotRodServer server = it.next();
        EmbeddedCacheManager cm = server.getCacheManager();
        it.remove();
        HotRodClientTestingUtil.killServers(server);
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{cm});
        this.cacheManagers.remove(cm);
    }

    @BeforeMethod(alwaysRun=true)
    public void createBeforeMethod() throws Throwable {
        if (this.cleanupAfterMethod()) {
            this.addr2hrServer.clear();
        }
        super.createBeforeMethod();
    }

    protected HitCountInterceptor getHitCountInterceptor(Cache<?, ?> cache) {
        return (HitCountInterceptor)cache.getAdvancedCache().getAsyncInterceptorChain().findInterceptorWithClass(HitCountInterceptor.class);
    }

    protected void assertOnlyServerHit(SocketAddress serverAddress) {
        this.assertServerHit(serverAddress, null, 1);
    }

    protected void assertServerHit(SocketAddress serverAddress, String cacheName, int expectedHits) {
        EmbeddedCacheManager cacheContainer = this.addr2hrServer.get(serverAddress).getCacheManager();
        HitCountInterceptor interceptor = this.getHitCountInterceptor(this.namedCache(cacheName, (CacheContainer)cacheContainer));
        assert (interceptor.getHits() == expectedHits) : "Expected " + expectedHits + " hit(s) for " + serverAddress + " but received " + interceptor.getHits();
        for (HotRodServer server : this.addr2hrServer.values()) {
            if (server.getCacheManager() == cacheContainer) continue;
            interceptor = this.getHitCountInterceptor(this.namedCache(cacheName, (CacheContainer)server.getCacheManager()));
            assert (interceptor.getHits() == 0) : "Expected 0 hits in " + serverAddress + " but got " + interceptor.getHits();
        }
    }

    private Cache<?, ?> namedCache(String cacheName, CacheContainer cacheContainer) {
        return cacheName == null ? cacheContainer.getCache() : cacheContainer.getCache(cacheName);
    }

    protected void assertNoHits() {
        for (HotRodServer server : this.addr2hrServer.values()) {
            HitCountInterceptor interceptor = this.getHitCountInterceptor(server.getCacheManager().getCache());
            assert (interceptor.getHits() == 0) : "Expected 0 hits but got " + interceptor.getHits();
        }
    }

    protected InetSocketAddress getAddress(HotRodServer hotRodServer) {
        InetSocketAddress socketAddress = new InetSocketAddress(hotRodServer.getHost(), hotRodServer.getPort());
        this.addr2hrServer.put(socketAddress, hotRodServer);
        return socketAddress;
    }

    protected void resetStats() {
        for (EmbeddedCacheManager manager : this.cacheManagers) {
            HitCountInterceptor cmi = this.getHitCountInterceptor(manager.getCache());
            cmi.reset();
        }
    }

    protected void addInterceptors() {
        this.addInterceptors(null);
    }

    protected void addInterceptors(String cacheName) {
        for (EmbeddedCacheManager manager : this.cacheManagers) {
            Cache<?, ?> cache = this.namedCache(cacheName, (CacheContainer)manager);
            this.addHitCountInterceptor(cache);
        }
    }

    private void addHitCountInterceptor(Cache<?, ?> cache) {
        HitCountInterceptor interceptor = new HitCountInterceptor();
        cache.getAdvancedCache().getAsyncInterceptorChain().addInterceptor((AsyncInterceptor)interceptor, 1);
    }

    @AfterClass(alwaysRun=true)
    protected void destroy() {
        this.addr2hrServer.values().forEach(xva$0 -> HotRodClientTestingUtil.killServers(xva$0));
        super.destroy();
    }

    public static class HitCountInterceptor
    extends BaseAsyncInterceptor {
        private static final Log log = LogFactory.getLog(HitCountInterceptor.class);
        private final AtomicInteger invocationCount = new AtomicInteger(0);

        public Object visitCommand(InvocationContext ctx, VisitableCommand command) throws Throwable {
            if (ctx.isOriginLocal()) {
                int count = this.invocationCount.incrementAndGet();
                log.infof("Hit %d for %s", (Object)count, (Object)command);
            }
            return this.invokeNext(ctx, command);
        }

        public int getHits() {
            return this.invocationCount.get();
        }

        public void reset() {
            this.invocationCount.set(0);
        }
    }
}

