/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ClientIntelligence;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.impl.transport.tcp.TcpTransportFactory;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.InternalRemoteCacheManager;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.client.hotrod.test.RemoteCacheManagerCallable;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.PingOnStartupTest")
public class PingOnStartupTest
extends MultiHotRodServersTest {
    protected void createCacheManagers() throws Throwable {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = HotRodTestingUtil.hotRodCacheConfiguration((org.infinispan.configuration.cache.ConfigurationBuilder)PingOnStartupTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false));
        this.createHotRodServers(2, builder);
    }

    public void testTopologyFetched() {
        HotRodServer hotRodServer2 = this.server(1);
        ConfigurationBuilder clientBuilder = new ConfigurationBuilder();
        clientBuilder.addServers("localhost:" + hotRodServer2.getPort() + ";localhost:" + hotRodServer2.getPort());
        HotRodClientTestingUtil.withRemoteCacheManager(new RemoteCacheManagerCallable(new InternalRemoteCacheManager(clientBuilder.build())){

            @Override
            public void call() {
                TcpTransportFactory tcpTransportFactory = (TcpTransportFactory)((InternalRemoteCacheManager)this.rcm).getTransportFactory();
                for (int i = 0; i < 10 && tcpTransportFactory.getServers().size() == 1; ++i) {
                    TestingUtil.sleepThread((long)1000L);
                }
                AssertJUnit.assertEquals((int)2, (int)tcpTransportFactory.getServers().size());
            }
        });
    }

    public void testBasicIntelligence() {
        ConfigurationBuilder clientBuilder = new ConfigurationBuilder();
        clientBuilder.addServer().host("localhost").port(this.server(0).getPort());
        clientBuilder.clientIntelligence(ClientIntelligence.BASIC);
        HotRodClientTestingUtil.withRemoteCacheManager(new RemoteCacheManagerCallable(new InternalRemoteCacheManager(clientBuilder.build())){

            @Override
            public void call() {
                this.rcm.getCache();
                TcpTransportFactory tcpTransportFactory = (TcpTransportFactory)((InternalRemoteCacheManager)this.rcm).getTransportFactory();
                AssertJUnit.assertEquals((int)1, (int)tcpTransportFactory.getServers().size());
            }
        });
    }

    public void testTopologyAwareIntelligence() {
        ConfigurationBuilder clientBuilder = new ConfigurationBuilder();
        clientBuilder.addServer().host("localhost").port(this.server(0).getPort());
        clientBuilder.clientIntelligence(ClientIntelligence.TOPOLOGY_AWARE);
        HotRodClientTestingUtil.withRemoteCacheManager(new RemoteCacheManagerCallable(new InternalRemoteCacheManager(clientBuilder.build())){

            @Override
            public void call() {
                this.rcm.getCache();
                TcpTransportFactory tcpTransportFactory = (TcpTransportFactory)((InternalRemoteCacheManager)this.rcm).getTransportFactory();
                AssertJUnit.assertEquals((int)2, (int)tcpTransportFactory.getServers().size());
            }
        });
    }

    public void testHashAwareIntelligence() {
        ConfigurationBuilder clientBuilder = new ConfigurationBuilder();
        clientBuilder.addServer().host("localhost").port(this.server(0).getPort());
        clientBuilder.clientIntelligence(ClientIntelligence.HASH_DISTRIBUTION_AWARE);
        HotRodClientTestingUtil.withRemoteCacheManager(new RemoteCacheManagerCallable(new InternalRemoteCacheManager(clientBuilder.build())){

            @Override
            public void call() {
                this.rcm.getCache();
                TcpTransportFactory tcpTransportFactory = (TcpTransportFactory)((InternalRemoteCacheManager)this.rcm).getTransportFactory();
                AssertJUnit.assertEquals((int)2, (int)tcpTransportFactory.getServers().size());
            }
        });
    }

    public void testGetCacheWithPingOnStartupDisabledMultipleNodes() {
        HotRodServer hotRodServer2 = this.server(1);
        ConfigurationBuilder clientBuilder = new ConfigurationBuilder();
        clientBuilder.addServers("boomoo:12345;localhost:" + hotRodServer2.getPort());
        HotRodClientTestingUtil.withRemoteCacheManager(new RemoteCacheManagerCallable(new RemoteCacheManager(clientBuilder.build())){

            @Override
            public void call() {
                RemoteCache cache = this.rcm.getCache();
                AssertJUnit.assertFalse((boolean)cache.containsKey((Object)"k"));
            }
        });
    }

    public void testGetCacheWorksIfNodeDown() {
        HotRodServer hotRodServer2 = this.server(1);
        ConfigurationBuilder clientBuilder = new ConfigurationBuilder();
        clientBuilder.addServers("boomoo:12345;localhost:" + hotRodServer2.getPort());
        HotRodClientTestingUtil.withRemoteCacheManager(new RemoteCacheManagerCallable(new RemoteCacheManager(clientBuilder.build())){

            @Override
            public void call() {
                this.rcm.getCache();
            }
        });
    }

    public void testGetCacheWorksIfNodeNotDown() {
        HotRodServer hotRodServer2 = this.server(1);
        ConfigurationBuilder clientBuilder = new ConfigurationBuilder();
        clientBuilder.addServers("localhost:" + hotRodServer2.getPort());
        HotRodClientTestingUtil.withRemoteCacheManager(new RemoteCacheManagerCallable(new RemoteCacheManager(clientBuilder.build())){

            @Override
            public void call() {
                this.rcm.getCache();
            }
        });
    }
}

